/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.payment.acquiring.model.PricedSupplierContractWithAcquirer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PriceSupplierContractWithAcquirerResponse
 */
@JsonPropertyOrder({
  PriceSupplierContractWithAcquirerResponse.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER,
  PriceSupplierContractWithAcquirerResponse.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE,
  PriceSupplierContractWithAcquirerResponse.JSON_PROPERTY_DISPLAY_CURRENCY,
  PriceSupplierContractWithAcquirerResponse.JSON_PROPERTY_SOURCE_URL,
  PriceSupplierContractWithAcquirerResponse.JSON_PROPERTY_TRACE_ID,
  PriceSupplierContractWithAcquirerResponse.JSON_PROPERTY_CONTRACT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-11T13:46:45.881586+07:00[Asia/Bangkok]")
public class PriceSupplierContractWithAcquirerResponse {
  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
  private String affiliateAccountIdentifier;

  /**
   * Type of identifier this is
   */
  public enum AffiliateAccountIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    AffiliateAccountIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
      for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
  private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_CONTRACT = "contract";
  private PricedSupplierContractWithAcquirer contract;

  public PriceSupplierContractWithAcquirerResponse() { 
  }

  @JsonCreator
  public PriceSupplierContractWithAcquirerResponse(
    @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY) String displayCurrency, 
    @JsonProperty(JSON_PROPERTY_SOURCE_URL) String sourceUrl, 
    @JsonProperty(JSON_PROPERTY_TRACE_ID) String traceId
  ) {
    this();
    this.displayCurrency = displayCurrency;
    this.sourceUrl = sourceUrl;
    this.traceId = traceId;
  }

  public PriceSupplierContractWithAcquirerResponse affiliateAccountIdentifier(String affiliateAccountIdentifier) {
    
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    return this;
  }

   /**
   * affiliate account making the request
   * @return affiliateAccountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "affiliate account making the request")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAffiliateAccountIdentifier() {
    return affiliateAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifier(String affiliateAccountIdentifier) {
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
  }


  public PriceSupplierContractWithAcquirerResponse affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    return this;
  }

   /**
   * Type of identifier this is
   * @return affiliateAccountIdentifierType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Type of identifier this is")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
    return affiliateAccountIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
  }


   /**
   * The desired quote
   * @return displayCurrency
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "USD", required = true, value = "The desired quote")
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }




   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }




   /**
   * Integrator can choose to include a unique identifier to help identify the collection of bookings
   * @return traceId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "integrator-booking-code-1", required = true, value = "Integrator can choose to include a unique identifier to help identify the collection of bookings")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }




  public PriceSupplierContractWithAcquirerResponse contract(PricedSupplierContractWithAcquirer contract) {
    
    this.contract = contract;
    return this;
  }

   /**
   * Get contract
   * @return contract
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricedSupplierContractWithAcquirer getContract() {
    return contract;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContract(PricedSupplierContractWithAcquirer contract) {
    this.contract = contract;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PriceSupplierContractWithAcquirerResponse priceSupplierContractWithAcquirerResponse = (PriceSupplierContractWithAcquirerResponse) o;
    return Objects.equals(this.affiliateAccountIdentifier, priceSupplierContractWithAcquirerResponse.affiliateAccountIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifierType, priceSupplierContractWithAcquirerResponse.affiliateAccountIdentifierType) &&
        Objects.equals(this.displayCurrency, priceSupplierContractWithAcquirerResponse.displayCurrency) &&
        Objects.equals(this.sourceUrl, priceSupplierContractWithAcquirerResponse.sourceUrl) &&
        Objects.equals(this.traceId, priceSupplierContractWithAcquirerResponse.traceId) &&
        Objects.equals(this.contract, priceSupplierContractWithAcquirerResponse.contract);
  }

  @Override
  public int hashCode() {
    return Objects.hash(affiliateAccountIdentifier, affiliateAccountIdentifierType, displayCurrency, sourceUrl, traceId, contract);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PriceSupplierContractWithAcquirerResponse {\n");
    sb.append("    affiliateAccountIdentifier: ").append(toIndentedString(affiliateAccountIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifierType: ").append(toIndentedString(affiliateAccountIdentifierType)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    contract: ").append(toIndentedString(contract)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

