/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.payment.acquiring.model.Acquirer;
import travel.wink.sdk.payment.acquiring.model.Moneys;
import travel.wink.sdk.payment.acquiring.model.PricedSupplierContractItemWithAcquirer;
import travel.wink.sdk.payment.acquiring.model.QuoteData;

@ApiModel(description="Details of the booking entries that went in for one particular supplier directly.")
@JsonPropertyOrder(value={"identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "acquirer", "externalSupplierIdentifier", "externalSupplierBookingCode", "externalTransactionIdentifier", "totalDisplayPrice", "totalInternalPrice", "totalSupplierPrice", "totalCapturePrice", "totalPrice"})
public class PricedSupplierContractWithAcquirer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private String supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private QuoteData displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private QuoteData supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private QuoteData internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private QuoteData capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<PricedSupplierContractItemWithAcquirer> itemList = new ArrayList<PricedSupplierContractItemWithAcquirer>();
    public static final String JSON_PROPERTY_ACQUIRER = "acquirer";
    private List<Acquirer> acquirer = new ArrayList<Acquirer>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private Moneys totalCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private Moneys totalPrice;

    public PricedSupplierContractWithAcquirer() {
    }

    @JsonCreator
    public PricedSupplierContractWithAcquirer(@JsonProperty(value="identifier") String identifier, @JsonProperty(value="supplierIdentifier") String supplierIdentifier, @JsonProperty(value="supplierName") String supplierName, @JsonProperty(value="itemList") List<PricedSupplierContractItemWithAcquirer> itemList, @JsonProperty(value="acquirer") List<Acquirer> acquirer, @JsonProperty(value="externalSupplierIdentifier") String externalSupplierIdentifier, @JsonProperty(value="externalSupplierBookingCode") String externalSupplierBookingCode) {
        this();
        this.identifier = identifier;
        this.supplierIdentifier = supplierIdentifier;
        this.supplierName = supplierName;
        this.itemList = itemList;
        this.acquirer = acquirer;
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    @Nonnull
    @ApiModelProperty(example="unique-supplier-booking-contract-1", required=true, value="Unique identifier used to track the contract. Create a UUID for this purpose.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    @ApiModelProperty(example="supplier-1", required=true, value="Supplier identifier")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="Supplier One", required=true, value="Supplier name")
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    public PricedSupplierContractWithAcquirer displayPriceQuote(QuoteData displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(QuoteData displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public PricedSupplierContractWithAcquirer supplierPriceQuote(QuoteData supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(QuoteData supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public PricedSupplierContractWithAcquirer internalPriceQuote(QuoteData internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(QuoteData internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public PricedSupplierContractWithAcquirer capturePriceQuote(QuoteData capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(QuoteData capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    @Nonnull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<PricedSupplierContractItemWithAcquirer> getItemList() {
        return this.itemList;
    }

    @Nonnull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="acquirer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Acquirer> getAcquirer() {
        return this.acquirer;
    }

    @Nonnull
    @ApiModelProperty(example="external-supplier-a", required=true, value="Track supplier with its external supplier identifier")
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="external-booking-code-1", required=true, value="External booking code generated by the affiliate")
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    public PricedSupplierContractWithAcquirer externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="external-transaction-1", required=true, value="External transaction identifier populated when agent responsible for acquiring")
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public PricedSupplierContractWithAcquirer totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public PricedSupplierContractWithAcquirer totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public PricedSupplierContractWithAcquirer totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public PricedSupplierContractWithAcquirer totalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public PricedSupplierContractWithAcquirer totalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedSupplierContractWithAcquirer pricedSupplierContractWithAcquirer = (PricedSupplierContractWithAcquirer)o;
        return Objects.equals(this.identifier, pricedSupplierContractWithAcquirer.identifier) && Objects.equals(this.supplierIdentifier, pricedSupplierContractWithAcquirer.supplierIdentifier) && Objects.equals(this.supplierName, pricedSupplierContractWithAcquirer.supplierName) && Objects.equals(this.displayPriceQuote, pricedSupplierContractWithAcquirer.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, pricedSupplierContractWithAcquirer.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, pricedSupplierContractWithAcquirer.internalPriceQuote) && Objects.equals(this.capturePriceQuote, pricedSupplierContractWithAcquirer.capturePriceQuote) && Objects.equals(this.itemList, pricedSupplierContractWithAcquirer.itemList) && Objects.equals(this.acquirer, pricedSupplierContractWithAcquirer.acquirer) && Objects.equals(this.externalSupplierIdentifier, pricedSupplierContractWithAcquirer.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, pricedSupplierContractWithAcquirer.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, pricedSupplierContractWithAcquirer.externalTransactionIdentifier) && Objects.equals(this.totalDisplayPrice, pricedSupplierContractWithAcquirer.totalDisplayPrice) && Objects.equals(this.totalInternalPrice, pricedSupplierContractWithAcquirer.totalInternalPrice) && Objects.equals(this.totalSupplierPrice, pricedSupplierContractWithAcquirer.totalSupplierPrice) && Objects.equals(this.totalCapturePrice, pricedSupplierContractWithAcquirer.totalCapturePrice) && Objects.equals(this.totalPrice, pricedSupplierContractWithAcquirer.totalPrice);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.acquirer, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.externalTransactionIdentifier, this.totalDisplayPrice, this.totalInternalPrice, this.totalSupplierPrice, this.totalCapturePrice, this.totalPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedSupplierContractWithAcquirer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    acquirer: ").append(this.toIndentedString(this.acquirer)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

