/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Holds tokenized credit card data
 */
@ApiModel(description = "Holds tokenized credit card data")
@JsonPropertyOrder({
  NmiCreditCardToken.JSON_PROPERTY_TOKEN,
  NmiCreditCardToken.JSON_PROPERTY_OBFUSCATED_NUMBER,
  NmiCreditCardToken.JSON_PROPERTY_EXPIRATION_DATE,
  NmiCreditCardToken.JSON_PROPERTY_SCHEME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T22:27:23.414685+07:00[Asia/Bangkok]")
public class NmiCreditCardToken {
  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  public static final String JSON_PROPERTY_OBFUSCATED_NUMBER = "obfuscatedNumber";
  private String obfuscatedNumber;

  public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
  private String expirationDate;

  public static final String JSON_PROPERTY_SCHEME = "scheme";
  private String scheme;

  public NmiCreditCardToken() { 
  }

  public NmiCreditCardToken token(String token) {
    
    this.token = token;
    return this;
  }

   /**
   * Tokenized credit card we can use to make a booking
   * @return token
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "H4waV564-UQ8FgJ-yXh495-Pb2ZeA3WNjvX", required = true, value = "Tokenized credit card we can use to make a booking")
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setToken(String token) {
    this.token = token;
  }


  public NmiCreditCardToken obfuscatedNumber(String obfuscatedNumber) {
    
    this.obfuscatedNumber = obfuscatedNumber;
    return this;
  }

   /**
   * Obfuscated credit card number used to create the token
   * @return obfuscatedNumber
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "424242******4242", required = true, value = "Obfuscated credit card number used to create the token")
  @JsonProperty(JSON_PROPERTY_OBFUSCATED_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getObfuscatedNumber() {
    return obfuscatedNumber;
  }


  @JsonProperty(JSON_PROPERTY_OBFUSCATED_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setObfuscatedNumber(String obfuscatedNumber) {
    this.obfuscatedNumber = obfuscatedNumber;
  }


  public NmiCreditCardToken expirationDate(String expirationDate) {
    
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * Credit card expiration date
   * @return expirationDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1224", required = true, value = "Credit card expiration date")
  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExpirationDate() {
    return expirationDate;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }


  public NmiCreditCardToken scheme(String scheme) {
    
    this.scheme = scheme;
    return this;
  }

   /**
   * Credit card type
   * @return scheme
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "visa", required = true, value = "Credit card type")
  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getScheme() {
    return scheme;
  }


  @JsonProperty(JSON_PROPERTY_SCHEME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setScheme(String scheme) {
    this.scheme = scheme;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NmiCreditCardToken nmiCreditCardToken = (NmiCreditCardToken) o;
    return Objects.equals(this.token, nmiCreditCardToken.token) &&
        Objects.equals(this.obfuscatedNumber, nmiCreditCardToken.obfuscatedNumber) &&
        Objects.equals(this.expirationDate, nmiCreditCardToken.expirationDate) &&
        Objects.equals(this.scheme, nmiCreditCardToken.scheme);
  }

  @Override
  public int hashCode() {
    return Objects.hash(token, obfuscatedNumber, expirationDate, scheme);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NmiCreditCardToken {\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    obfuscatedNumber: ").append(toIndentedString(obfuscatedNumber)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    scheme: ").append(toIndentedString(scheme)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

