package travel.wink.sdk.payment.acquiring.api;

import travel.wink.sdk.payment.acquiring.invoker.ApiClient;

import travel.wink.sdk.payment.acquiring.model.BookingContractResponse;
import travel.wink.sdk.payment.acquiring.model.CreateNewCustomerStripePaymentIntentRequest;
import travel.wink.sdk.payment.acquiring.model.CreateNewCustomerStripePaymentIntentResponse;
import travel.wink.sdk.payment.acquiring.model.CreateStripeSaleRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:11:02.512333+07:00[Asia/Bangkok]")
public class StripeApi {
    private ApiClient apiClient;

    public StripeApi() {
        this(new ApiClient());
    }

    @Autowired
    public StripeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Stripe Payment Intent
     * Creates a Stripe PaymentIntent and creates a new customer for that intent.
     * <p><b>200</b> - OK
     * @param createNewCustomerStripePaymentIntentRequest The createNewCustomerStripePaymentIntentRequest parameter
     * @return CreateNewCustomerStripePaymentIntentResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPaymentIntentRequestCreation(CreateNewCustomerStripePaymentIntentRequest createNewCustomerStripePaymentIntentRequest) throws WebClientResponseException {
        Object postBody = createNewCustomerStripePaymentIntentRequest;
        // verify the required parameter 'createNewCustomerStripePaymentIntentRequest' is set
        if (createNewCustomerStripePaymentIntentRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createNewCustomerStripePaymentIntentRequest' when calling createPaymentIntent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<CreateNewCustomerStripePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreateNewCustomerStripePaymentIntentResponse>() {};
        return apiClient.invokeAPI("/contract/payment/stripe/paymentintent", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Stripe Payment Intent
     * Creates a Stripe PaymentIntent and creates a new customer for that intent.
     * <p><b>200</b> - OK
     * @param createNewCustomerStripePaymentIntentRequest The createNewCustomerStripePaymentIntentRequest parameter
     * @return CreateNewCustomerStripePaymentIntentResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateNewCustomerStripePaymentIntentResponse> createPaymentIntent(CreateNewCustomerStripePaymentIntentRequest createNewCustomerStripePaymentIntentRequest) throws WebClientResponseException {
        ParameterizedTypeReference<CreateNewCustomerStripePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreateNewCustomerStripePaymentIntentResponse>() {};
        return createPaymentIntentRequestCreation(createNewCustomerStripePaymentIntentRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreateNewCustomerStripePaymentIntentResponse>> createPaymentIntentWithHttpInfo(CreateNewCustomerStripePaymentIntentRequest createNewCustomerStripePaymentIntentRequest) throws WebClientResponseException {
        ParameterizedTypeReference<CreateNewCustomerStripePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreateNewCustomerStripePaymentIntentResponse>() {};
        return createPaymentIntentRequestCreation(createNewCustomerStripePaymentIntentRequest).toEntity(localVarReturnType);
    }
    /**
     * Complete Stripe Capture
     * Upon a successful card capture, we store customer details for later use.
     * <p><b>200</b> - OK
     * @param createStripeSaleRequest The createStripeSaleRequest parameter
     * @return BookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec savePayingCustomerRequestCreation(CreateStripeSaleRequest createStripeSaleRequest) throws WebClientResponseException {
        Object postBody = createStripeSaleRequest;
        // verify the required parameter 'createStripeSaleRequest' is set
        if (createStripeSaleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStripeSaleRequest' when calling savePayingCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return apiClient.invokeAPI("/contract/payment/stripe/sale", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Complete Stripe Capture
     * Upon a successful card capture, we store customer details for later use.
     * <p><b>200</b> - OK
     * @param createStripeSaleRequest The createStripeSaleRequest parameter
     * @return BookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractResponse> savePayingCustomer(CreateStripeSaleRequest createStripeSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return savePayingCustomerRequestCreation(createStripeSaleRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractResponse>> savePayingCustomerWithHttpInfo(CreateStripeSaleRequest createStripeSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return savePayingCustomerRequestCreation(createStripeSaleRequest).toEntity(localVarReturnType);
    }
}
