/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.3.4-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Affiliate details response contains details about the affiliate facilitating the sale.
 */
@ApiModel(description = "Affiliate details response contains details about the affiliate facilitating the sale.")
@JsonPropertyOrder({
  AffiliateDetailsResponse.JSON_PROPERTY_AFFILIATE_IDENTIFIER,
  AffiliateDetailsResponse.JSON_PROPERTY_AFFILIATE_NAME,
  AffiliateDetailsResponse.JSON_PROPERTY_AFFILIATE_URL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:11:02.512333+07:00[Asia/Bangkok]")
public class AffiliateDetailsResponse {
  public static final String JSON_PROPERTY_AFFILIATE_IDENTIFIER = "affiliateIdentifier";
  private UUID affiliateIdentifier;

  public static final String JSON_PROPERTY_AFFILIATE_NAME = "affiliateName";
  private String affiliateName;

  public static final String JSON_PROPERTY_AFFILIATE_URL = "affiliateUrl";
  private String affiliateUrl;

  public AffiliateDetailsResponse() { 
  }

  public AffiliateDetailsResponse affiliateIdentifier(UUID affiliateIdentifier) {
    
    this.affiliateIdentifier = affiliateIdentifier;
    return this;
  }

   /**
   * Affiliate identifier of entity making the same
   * @return affiliateIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Affiliate identifier of entity making the same")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getAffiliateIdentifier() {
    return affiliateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateIdentifier(UUID affiliateIdentifier) {
    this.affiliateIdentifier = affiliateIdentifier;
  }


  public AffiliateDetailsResponse affiliateName(String affiliateName) {
    
    this.affiliateName = affiliateName;
    return this;
  }

   /**
   * Affiliate name of entity making the same
   * @return affiliateName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "My Affiliate", value = "Affiliate name of entity making the same")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateName() {
    return affiliateName;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateName(String affiliateName) {
    this.affiliateName = affiliateName;
  }


  public AffiliateDetailsResponse affiliateUrl(String affiliateUrl) {
    
    this.affiliateUrl = affiliateUrl;
    return this;
  }

   /**
   * Affiliate url of entity making the same
   * @return affiliateUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://www.my-affiliate.com", value = "Affiliate url of entity making the same")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateUrl() {
    return affiliateUrl;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateUrl(String affiliateUrl) {
    this.affiliateUrl = affiliateUrl;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AffiliateDetailsResponse affiliateDetailsResponse = (AffiliateDetailsResponse) o;
    return Objects.equals(this.affiliateIdentifier, affiliateDetailsResponse.affiliateIdentifier) &&
        Objects.equals(this.affiliateName, affiliateDetailsResponse.affiliateName) &&
        Objects.equals(this.affiliateUrl, affiliateDetailsResponse.affiliateUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(affiliateIdentifier, affiliateName, affiliateUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AffiliateDetailsResponse {\n");
    sb.append("    affiliateIdentifier: ").append(toIndentedString(affiliateIdentifier)).append("\n");
    sb.append("    affiliateName: ").append(toIndentedString(affiliateName)).append("\n");
    sb.append("    affiliateUrl: ").append(toIndentedString(affiliateUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

