/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.3.4-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import travel.wink.sdk.payment.acquiring.model.VariableCharge;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RawBeneficiary is a registered account with rights to compensation within a booking.
 */
@ApiModel(description = "RawBeneficiary is a registered account with rights to compensation within a booking.")
@JsonPropertyOrder({
  RawBeneficiary.JSON_PROPERTY_IDENTIFIER,
  RawBeneficiary.JSON_PROPERTY_IDENTIFIER_TYPE,
  RawBeneficiary.JSON_PROPERTY_AMOUNT_DUE,
  RawBeneficiary.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:11:02.512333+07:00[Asia/Bangkok]")
public class RawBeneficiary {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  /**
   * The identifierType tells us what type of identifier this is
   */
  public enum IdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    IdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IdentifierTypeEnum fromValue(String value) {
      for (IdentifierTypeEnum b : IdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_IDENTIFIER_TYPE = "identifierType";
  private IdentifierTypeEnum identifierType;

  public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
  private VariableCharge amountDue;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    SALE("SALE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public RawBeneficiary() { 
  }

  public RawBeneficiary identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * identifier of beneficiary that can map to an account with us
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "identifier of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RawBeneficiary identifierType(IdentifierTypeEnum identifierType) {
    
    this.identifierType = identifierType;
    return this;
  }

   /**
   * The identifierType tells us what type of identifier this is
   * @return identifierType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "INTERNAL", required = true, value = "The identifierType tells us what type of identifier this is")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public IdentifierTypeEnum getIdentifierType() {
    return identifierType;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifierType(IdentifierTypeEnum identifierType) {
    this.identifierType = identifierType;
  }


  public RawBeneficiary amountDue(VariableCharge amountDue) {
    
    this.amountDue = amountDue;
    return this;
  }

   /**
   * Get amountDue
   * @return amountDue
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getAmountDue() {
    return amountDue;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDue(VariableCharge amountDue) {
    this.amountDue = amountDue;
  }


  public RawBeneficiary type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "The type of beneficiary payment.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RawBeneficiary rawBeneficiary = (RawBeneficiary) o;
    return Objects.equals(this.identifier, rawBeneficiary.identifier) &&
        Objects.equals(this.identifierType, rawBeneficiary.identifierType) &&
        Objects.equals(this.amountDue, rawBeneficiary.amountDue) &&
        Objects.equals(this.type, rawBeneficiary.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, identifierType, amountDue, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RawBeneficiary {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    identifierType: ").append(toIndentedString(identifierType)).append("\n");
    sb.append("    amountDue: ").append(toIndentedString(amountDue)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

