/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.payment.acquiring.model.Beneficiary;
import travel.wink.sdk.payment.acquiring.model.BookingUser;
import travel.wink.sdk.payment.acquiring.model.DailyRate;
import travel.wink.sdk.payment.acquiring.model.Itinerary;
import travel.wink.sdk.payment.acquiring.model.Moneys;
import travel.wink.sdk.payment.acquiring.model.SupplierContractItemPolicy;

@ApiModel(description="Holds one booking line item for a specific supplier.")
@JsonPropertyOrder(value={"supplierItemBookingCode", "user", "nameInEnglish", "descriptionInEnglish", "totalSourcePrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice", "totalCapturePrice", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "tokensEarned", "dailyRateList", "cancelled", "totalSourcePriceAfterCancellation", "totalDisplayPriceAfterCancellation", "totalSupplierPriceAfterCancellation", "totalInternalPriceAfterCancellation", "totalCapturePriceAfterCancellation", "cancellableByTraveler", "cancellableBySupplier", "cancellableWithNoCharges"})
public class BookingContractItem {
    public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
    private String supplierItemBookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUser user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
    private Moneys totalSourcePrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private Moneys totalCapturePrice;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private Itinerary itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<Beneficiary> beneficiaryList = new ArrayList<Beneficiary>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
    private Long tokensEarned;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<DailyRate> dailyRateList = null;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION = "totalSourcePriceAfterCancellation";
    private Moneys totalSourcePriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION = "totalDisplayPriceAfterCancellation";
    private Moneys totalDisplayPriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION = "totalSupplierPriceAfterCancellation";
    private Moneys totalSupplierPriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION = "totalInternalPriceAfterCancellation";
    private Moneys totalInternalPriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION = "totalCapturePriceAfterCancellation";
    private Moneys totalCapturePriceAfterCancellation;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;

    public BookingContractItem supplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="TP-ASDFG1234", required=true, value="Booking code identifying the supplier line item.")
    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierItemBookingCode() {
        return this.supplierItemBookingCode;
    }

    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
    }

    public BookingContractItem user(BookingUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUser user) {
        this.user = user;
    }

    public BookingContractItem nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Deluxe King", required=true, value="Name of item in English included in booking.")
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public BookingContractItem descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="This is the best deluxe king that money can buy.", required=true, value="Short description in English of item included in booking.")
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public BookingContractItem totalSourcePrice(Moneys totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getTotalSourcePrice() {
        return this.totalSourcePrice;
    }

    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalSourcePrice(Moneys totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
    }

    public BookingContractItem totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public BookingContractItem totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public BookingContractItem totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public BookingContractItem totalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public BookingContractItem itinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Itinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
    }

    public BookingContractItem pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="How to calculate the total amount.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public BookingContractItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LODGING", required=true, value="Type of item this is.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BookingContractItem beneficiaryList(List<Beneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public BookingContractItem addBeneficiaryListItem(Beneficiary beneficiaryListItem) {
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<Beneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<Beneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public BookingContractItem payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PREPAY", required=true, value="When to charge for this item.")
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public BookingContractItem policy(SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public BookingContractItem externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="room-type-1", value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public BookingContractItem tokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Tokens minted for this item")
    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTokensEarned() {
        return this.tokensEarned;
    }

    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
    }

    public BookingContractItem dailyRateList(List<DailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public BookingContractItem addDailyRateListItem(DailyRate dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<DailyRate>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyRate> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<DailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public BookingContractItem cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractItem totalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
        this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSourcePriceAfterCancellation() {
        return this.totalSourcePriceAfterCancellation;
    }

    @JsonProperty(value="totalSourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
        this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
    }

    public BookingContractItem totalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
        this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPriceAfterCancellation() {
        return this.totalDisplayPriceAfterCancellation;
    }

    @JsonProperty(value="totalDisplayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
        this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
    }

    public BookingContractItem totalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
        this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPriceAfterCancellation() {
        return this.totalSupplierPriceAfterCancellation;
    }

    @JsonProperty(value="totalSupplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
        this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
    }

    public BookingContractItem totalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
        this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPriceAfterCancellation() {
        return this.totalInternalPriceAfterCancellation;
    }

    @JsonProperty(value="totalInternalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
        this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
    }

    public BookingContractItem totalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
        this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePriceAfterCancellation() {
        return this.totalCapturePriceAfterCancellation;
    }

    @JsonProperty(value="totalCapturePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
        this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
    }

    public BookingContractItem cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled by the traveller.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractItem cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractItem cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled and whether cancellation charges might still occur.")
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractItem bookingContractItem = (BookingContractItem)o;
        return Objects.equals(this.supplierItemBookingCode, bookingContractItem.supplierItemBookingCode) && Objects.equals(this.user, bookingContractItem.user) && Objects.equals(this.nameInEnglish, bookingContractItem.nameInEnglish) && Objects.equals(this.descriptionInEnglish, bookingContractItem.descriptionInEnglish) && Objects.equals(this.totalSourcePrice, bookingContractItem.totalSourcePrice) && Objects.equals(this.totalDisplayPrice, bookingContractItem.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, bookingContractItem.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, bookingContractItem.totalInternalPrice) && Objects.equals(this.totalCapturePrice, bookingContractItem.totalCapturePrice) && Objects.equals(this.itinerary, bookingContractItem.itinerary) && Objects.equals((Object)this.pricingType, (Object)bookingContractItem.pricingType) && Objects.equals((Object)this.type, (Object)bookingContractItem.type) && Objects.equals(this.beneficiaryList, bookingContractItem.beneficiaryList) && Objects.equals((Object)this.payable, (Object)bookingContractItem.payable) && Objects.equals(this.policy, bookingContractItem.policy) && Objects.equals(this.externalIdentifier, bookingContractItem.externalIdentifier) && Objects.equals(this.tokensEarned, bookingContractItem.tokensEarned) && Objects.equals(this.dailyRateList, bookingContractItem.dailyRateList) && Objects.equals(this.cancelled, bookingContractItem.cancelled) && Objects.equals(this.totalSourcePriceAfterCancellation, bookingContractItem.totalSourcePriceAfterCancellation) && Objects.equals(this.totalDisplayPriceAfterCancellation, bookingContractItem.totalDisplayPriceAfterCancellation) && Objects.equals(this.totalSupplierPriceAfterCancellation, bookingContractItem.totalSupplierPriceAfterCancellation) && Objects.equals(this.totalInternalPriceAfterCancellation, bookingContractItem.totalInternalPriceAfterCancellation) && Objects.equals(this.totalCapturePriceAfterCancellation, bookingContractItem.totalCapturePriceAfterCancellation) && Objects.equals(this.cancellableByTraveler, bookingContractItem.cancellableByTraveler) && Objects.equals(this.cancellableBySupplier, bookingContractItem.cancellableBySupplier) && Objects.equals(this.cancellableWithNoCharges, bookingContractItem.cancellableWithNoCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.supplierItemBookingCode, this.user, this.nameInEnglish, this.descriptionInEnglish, this.totalSourcePrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice, this.totalCapturePrice, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.tokensEarned, this.dailyRateList, this.cancelled, this.totalSourcePriceAfterCancellation, this.totalDisplayPriceAfterCancellation, this.totalSupplierPriceAfterCancellation, this.totalInternalPriceAfterCancellation, this.totalCapturePriceAfterCancellation, this.cancellableByTraveler, this.cancellableBySupplier, this.cancellableWithNoCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractItem {\n");
        sb.append("    supplierItemBookingCode: ").append(this.toIndentedString(this.supplierItemBookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    totalSourcePrice: ").append(this.toIndentedString(this.totalSourcePrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    tokensEarned: ").append(this.toIndentedString(this.tokensEarned)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    totalSourcePriceAfterCancellation: ").append(this.toIndentedString(this.totalSourcePriceAfterCancellation)).append("\n");
        sb.append("    totalDisplayPriceAfterCancellation: ").append(this.toIndentedString(this.totalDisplayPriceAfterCancellation)).append("\n");
        sb.append("    totalSupplierPriceAfterCancellation: ").append(this.toIndentedString(this.totalSupplierPriceAfterCancellation)).append("\n");
        sb.append("    totalInternalPriceAfterCancellation: ").append(this.toIndentedString(this.totalInternalPriceAfterCancellation)).append("\n");
        sb.append("    totalCapturePriceAfterCancellation: ").append(this.toIndentedString(this.totalCapturePriceAfterCancellation)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        ADULT("PER_ADULT"),
        CHILD("PER_CHILD"),
        NIGHT("PER_NIGHT"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR"),
        PERSON_PER_STAY("PER_PERSON_PER_STAY"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_STAY("PER_ADULT_PER_STAY"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_STAY("PER_CHILD_PER_STAY"),
        USE("PER_USE"),
        PERSON_PER_USE("PER_PERSON_PER_USE");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

