/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="Card holder details")
@JsonPropertyOrder(value={"nameOnCard", "phone", "email", "countryCode"})
public class StripeCardholder {
    public static final String JSON_PROPERTY_NAME_ON_CARD = "nameOnCard";
    private String nameOnCard;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private String phone;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;

    public StripeCardholder nameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Card holder full name")
    @JsonProperty(value="nameOnCard")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameOnCard() {
        return this.nameOnCard;
    }

    @JsonProperty(value="nameOnCard")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    public StripeCardholder phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Card holder phone number")
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhone(String phone) {
        this.phone = phone;
    }

    public StripeCardholder email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Card holder email")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public StripeCardholder countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Card holder billing country code")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StripeCardholder stripeCardholder = (StripeCardholder)o;
        return Objects.equals(this.nameOnCard, stripeCardholder.nameOnCard) && Objects.equals(this.phone, stripeCardholder.phone) && Objects.equals(this.email, stripeCardholder.email) && Objects.equals(this.countryCode, stripeCardholder.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.nameOnCard, this.phone, this.email, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StripeCardholder {\n");
        sb.append("    nameOnCard: ").append(this.toIndentedString(this.nameOnCard)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

