/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.Moneys;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Beneficiary is a registered account with rights to compensation within a booking.")
@JsonPropertyOrder(value={"accountIdentifier", "accountName", "accountEmail", "accountUrl", "amountDueInSourceCurrency", "amountDueInDisplayCurrency", "amountDueInSupplierCurrency", "amountDueInInternalCurrency", "amountDueInCaptureCurrency", "type", "amountDueInSourcePriceAfterRefund", "amountDueInDisplayPriceAfterRefund", "amountDueInSupplierPriceAfterRefund", "amountDueInInternalPriceAfterRefund", "amountDueInCapturePriceAfterRefund"})
public class Beneficiary {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private String accountIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_ACCOUNT_URL = "accountUrl";
    private String accountUrl;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
    private Moneys amountDueInSourceCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
    private Moneys amountDueInDisplayCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
    private Moneys amountDueInSupplierCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
    private Moneys amountDueInInternalCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
    private Moneys amountDueInCaptureCurrency;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_PRICE_AFTER_REFUND = "amountDueInSourcePriceAfterRefund";
    private Moneys amountDueInSourcePriceAfterRefund;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_PRICE_AFTER_REFUND = "amountDueInDisplayPriceAfterRefund";
    private Moneys amountDueInDisplayPriceAfterRefund;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_PRICE_AFTER_REFUND = "amountDueInSupplierPriceAfterRefund";
    private Moneys amountDueInSupplierPriceAfterRefund;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_PRICE_AFTER_REFUND = "amountDueInInternalPriceAfterRefund";
    private Moneys amountDueInInternalPriceAfterRefund;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_PRICE_AFTER_REFUND = "amountDueInCapturePriceAfterRefund";
    private Moneys amountDueInCapturePriceAfterRefund;

    public Beneficiary accountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="account-1", required=true, value="accountIdentifier of beneficiary that can map to an account with us")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public Beneficiary accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Account 1", required=true, value="accountName of beneficiary that can map to an account with us")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Beneficiary accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="account@one.com", required=true, value="accountEmail of beneficiary that can map to an account with us")
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public Beneficiary accountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://some.url", required=true, value="accountUrl of beneficiary that can map to an account with us")
    @JsonProperty(value="accountUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountUrl() {
        return this.accountUrl;
    }

    @JsonProperty(value="accountUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
    }

    public Beneficiary amountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInSourceCurrency() {
        return this.amountDueInSourceCurrency;
    }

    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    }

    public Beneficiary amountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInDisplayCurrency() {
        return this.amountDueInDisplayCurrency;
    }

    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    }

    public Beneficiary amountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInSupplierCurrency() {
        return this.amountDueInSupplierCurrency;
    }

    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    }

    public Beneficiary amountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInInternalCurrency() {
        return this.amountDueInInternalCurrency;
    }

    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    }

    public Beneficiary amountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInCaptureCurrency() {
        return this.amountDueInCaptureCurrency;
    }

    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    }

    public Beneficiary type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The type of beneficiary payment.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Beneficiary amountDueInSourcePriceAfterRefund(Moneys amountDueInSourcePriceAfterRefund) {
        this.amountDueInSourcePriceAfterRefund = amountDueInSourcePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInSourcePriceAfterRefund() {
        return this.amountDueInSourcePriceAfterRefund;
    }

    @JsonProperty(value="amountDueInSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInSourcePriceAfterRefund(Moneys amountDueInSourcePriceAfterRefund) {
        this.amountDueInSourcePriceAfterRefund = amountDueInSourcePriceAfterRefund;
    }

    public Beneficiary amountDueInDisplayPriceAfterRefund(Moneys amountDueInDisplayPriceAfterRefund) {
        this.amountDueInDisplayPriceAfterRefund = amountDueInDisplayPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInDisplayPriceAfterRefund() {
        return this.amountDueInDisplayPriceAfterRefund;
    }

    @JsonProperty(value="amountDueInDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInDisplayPriceAfterRefund(Moneys amountDueInDisplayPriceAfterRefund) {
        this.amountDueInDisplayPriceAfterRefund = amountDueInDisplayPriceAfterRefund;
    }

    public Beneficiary amountDueInSupplierPriceAfterRefund(Moneys amountDueInSupplierPriceAfterRefund) {
        this.amountDueInSupplierPriceAfterRefund = amountDueInSupplierPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInSupplierPriceAfterRefund() {
        return this.amountDueInSupplierPriceAfterRefund;
    }

    @JsonProperty(value="amountDueInSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInSupplierPriceAfterRefund(Moneys amountDueInSupplierPriceAfterRefund) {
        this.amountDueInSupplierPriceAfterRefund = amountDueInSupplierPriceAfterRefund;
    }

    public Beneficiary amountDueInInternalPriceAfterRefund(Moneys amountDueInInternalPriceAfterRefund) {
        this.amountDueInInternalPriceAfterRefund = amountDueInInternalPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInInternalPriceAfterRefund() {
        return this.amountDueInInternalPriceAfterRefund;
    }

    @JsonProperty(value="amountDueInInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInInternalPriceAfterRefund(Moneys amountDueInInternalPriceAfterRefund) {
        this.amountDueInInternalPriceAfterRefund = amountDueInInternalPriceAfterRefund;
    }

    public Beneficiary amountDueInCapturePriceAfterRefund(Moneys amountDueInCapturePriceAfterRefund) {
        this.amountDueInCapturePriceAfterRefund = amountDueInCapturePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="amountDueInCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getAmountDueInCapturePriceAfterRefund() {
        return this.amountDueInCapturePriceAfterRefund;
    }

    @JsonProperty(value="amountDueInCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountDueInCapturePriceAfterRefund(Moneys amountDueInCapturePriceAfterRefund) {
        this.amountDueInCapturePriceAfterRefund = amountDueInCapturePriceAfterRefund;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Beneficiary beneficiary = (Beneficiary)o;
        return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) && Objects.equals(this.accountName, beneficiary.accountName) && Objects.equals(this.accountEmail, beneficiary.accountEmail) && Objects.equals(this.accountUrl, beneficiary.accountUrl) && Objects.equals(this.amountDueInSourceCurrency, beneficiary.amountDueInSourceCurrency) && Objects.equals(this.amountDueInDisplayCurrency, beneficiary.amountDueInDisplayCurrency) && Objects.equals(this.amountDueInSupplierCurrency, beneficiary.amountDueInSupplierCurrency) && Objects.equals(this.amountDueInInternalCurrency, beneficiary.amountDueInInternalCurrency) && Objects.equals(this.amountDueInCaptureCurrency, beneficiary.amountDueInCaptureCurrency) && Objects.equals((Object)this.type, (Object)beneficiary.type) && Objects.equals(this.amountDueInSourcePriceAfterRefund, beneficiary.amountDueInSourcePriceAfterRefund) && Objects.equals(this.amountDueInDisplayPriceAfterRefund, beneficiary.amountDueInDisplayPriceAfterRefund) && Objects.equals(this.amountDueInSupplierPriceAfterRefund, beneficiary.amountDueInSupplierPriceAfterRefund) && Objects.equals(this.amountDueInInternalPriceAfterRefund, beneficiary.amountDueInInternalPriceAfterRefund) && Objects.equals(this.amountDueInCapturePriceAfterRefund, beneficiary.amountDueInCapturePriceAfterRefund);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.accountName, this.accountEmail, this.accountUrl, this.amountDueInSourceCurrency, this.amountDueInDisplayCurrency, this.amountDueInSupplierCurrency, this.amountDueInInternalCurrency, this.amountDueInCaptureCurrency, this.type, this.amountDueInSourcePriceAfterRefund, this.amountDueInDisplayPriceAfterRefund, this.amountDueInSupplierPriceAfterRefund, this.amountDueInInternalPriceAfterRefund, this.amountDueInCapturePriceAfterRefund});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Beneficiary {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    accountUrl: ").append(this.toIndentedString(this.accountUrl)).append("\n");
        sb.append("    amountDueInSourceCurrency: ").append(this.toIndentedString(this.amountDueInSourceCurrency)).append("\n");
        sb.append("    amountDueInDisplayCurrency: ").append(this.toIndentedString(this.amountDueInDisplayCurrency)).append("\n");
        sb.append("    amountDueInSupplierCurrency: ").append(this.toIndentedString(this.amountDueInSupplierCurrency)).append("\n");
        sb.append("    amountDueInInternalCurrency: ").append(this.toIndentedString(this.amountDueInInternalCurrency)).append("\n");
        sb.append("    amountDueInCaptureCurrency: ").append(this.toIndentedString(this.amountDueInCaptureCurrency)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amountDueInSourcePriceAfterRefund: ").append(this.toIndentedString(this.amountDueInSourcePriceAfterRefund)).append("\n");
        sb.append("    amountDueInDisplayPriceAfterRefund: ").append(this.toIndentedString(this.amountDueInDisplayPriceAfterRefund)).append("\n");
        sb.append("    amountDueInSupplierPriceAfterRefund: ").append(this.toIndentedString(this.amountDueInSupplierPriceAfterRefund)).append("\n");
        sb.append("    amountDueInInternalPriceAfterRefund: ").append(this.toIndentedString(this.amountDueInInternalPriceAfterRefund)).append("\n");
        sb.append("    amountDueInCapturePriceAfterRefund: ").append(this.toIndentedString(this.amountDueInCapturePriceAfterRefund)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        TRIP_PAY("TRIP_PAY"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

