/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.BookingContractItem;
import io.trippay.sdk.payment.acquiring.model.BookingContractPaymentDetails;
import io.trippay.sdk.payment.acquiring.model.Itinerary;
import io.trippay.sdk.payment.acquiring.model.Moneys;
import io.trippay.sdk.payment.acquiring.model.Quote;
import io.trippay.sdk.payment.acquiring.model.Refund;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="A booking record is the contract that got created after a successful payment was submitted.")
@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "externalSupplierIdentifier", "externalSupplierBookingCode", "payment", "cancelled", "cancelledOn", "canceller", "cancellationType", "cancellerUserIdentifier", "cancelReason", "fundsAddedToLedger", "fundsProcessed", "refunds", "cancellableByTraveler", "refundedCapturePrice", "cancellableBySupplier", "cancellableWithNoCharges", "cancellableWithPotentialCharges", "lodging", "refundedDisplayPrice", "refundedInternalPrice", "refundedSupplierPrice", "refundedSourcePrice", "refundableDisplayPrice", "refundableInternalPrice", "refundableSupplierPrice", "refundableSourcePrice", "refundableCapturePrice", "totalTokensEarned", "lodgingItinerary", "totalDisplayPrice", "totalInternalPrice", "totalSupplierPrice", "totalSourcePrice", "totalCapturePrice", "totalDisplayPriceAfterRefund", "totalInternalPriceAfterRefund", "totalSupplierPriceAfterRefund", "totalSourcePriceAfterRefund", "totalCapturePriceAfterRefund"})
public class BookingContract {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private Quote displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private Quote supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private Quote internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private Quote capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<BookingContractItem> itemList = new ArrayList<BookingContractItem>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_PAYMENT = "payment";
    private BookingContractPaymentDetails payment;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled;
    public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
    private LocalDateTime cancelledOn;
    public static final String JSON_PROPERTY_CANCELLER = "canceller";
    private CancellerEnum canceller;
    public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
    private CancellationTypeEnum cancellationType;
    public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
    private String cancellerUserIdentifier;
    public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
    private String cancelReason;
    public static final String JSON_PROPERTY_FUNDS_ADDED_TO_LEDGER = "fundsAddedToLedger";
    private Boolean fundsAddedToLedger;
    public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
    private Boolean fundsProcessed;
    public static final String JSON_PROPERTY_REFUNDS = "refunds";
    private List<Refund> refunds = null;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_REFUNDED_CAPTURE_PRICE = "refundedCapturePrice";
    private Moneys refundedCapturePrice;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
    private Boolean cancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_LODGING = "lodging";
    private BookingContractItem lodging;
    public static final String JSON_PROPERTY_REFUNDED_DISPLAY_PRICE = "refundedDisplayPrice";
    private Moneys refundedDisplayPrice;
    public static final String JSON_PROPERTY_REFUNDED_INTERNAL_PRICE = "refundedInternalPrice";
    private Moneys refundedInternalPrice;
    public static final String JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE = "refundedSupplierPrice";
    private Moneys refundedSupplierPrice;
    public static final String JSON_PROPERTY_REFUNDED_SOURCE_PRICE = "refundedSourcePrice";
    private Moneys refundedSourcePrice;
    public static final String JSON_PROPERTY_REFUNDABLE_DISPLAY_PRICE = "refundableDisplayPrice";
    private Boolean refundableDisplayPrice;
    public static final String JSON_PROPERTY_REFUNDABLE_INTERNAL_PRICE = "refundableInternalPrice";
    private Boolean refundableInternalPrice;
    public static final String JSON_PROPERTY_REFUNDABLE_SUPPLIER_PRICE = "refundableSupplierPrice";
    private Boolean refundableSupplierPrice;
    public static final String JSON_PROPERTY_REFUNDABLE_SOURCE_PRICE = "refundableSourcePrice";
    private Boolean refundableSourcePrice;
    public static final String JSON_PROPERTY_REFUNDABLE_CAPTURE_PRICE = "refundableCapturePrice";
    private Boolean refundableCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
    private Long totalTokensEarned;
    public static final String JSON_PROPERTY_LODGING_ITINERARY = "lodgingItinerary";
    private Itinerary lodgingItinerary;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
    private Moneys totalSourcePrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private Moneys totalCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
    private Moneys totalDisplayPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
    private Moneys totalInternalPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
    private Moneys totalSupplierPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
    private Moneys totalSourcePriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
    private Moneys totalCapturePriceAfterRefund;

    public BookingContract id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="doc-1", value="Document UUID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BookingContract createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public BookingContract lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public BookingContract version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Long version) {
        this.version = version;
    }

    public BookingContract ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="111.222.333.444", required=true, value="Caller's IP address")
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public BookingContract traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="T-123456", required=true, value="Way to track which booking contracts were made together")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public BookingContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public BookingContract identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="unique-supplier-booking-contract-1", required=true, value="Unique identifier used to track the contract.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public BookingContract supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Supplier identifier")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public BookingContract supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Supplier One", required=true, value="Supplier name")
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BookingContract displayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public BookingContract supplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public BookingContract internalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public BookingContract capturePriceQuote(Quote capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(Quote capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    public BookingContract itemList(List<BookingContractItem> itemList) {
        this.itemList = itemList;
        return this;
    }

    public BookingContract addItemListItem(BookingContractItem itemListItem) {
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Holds one booking line item for a specific supplier.")
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BookingContractItem> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(List<BookingContractItem> itemList) {
        this.itemList = itemList;
    }

    public BookingContract externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="supplier-a", value="Contract creator can choose to geoname this record with her own identifier")
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public BookingContract externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="external-booking-code-1", value="External booking code generated by the caller")
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public BookingContract payment(BookingContractPaymentDetails payment) {
        this.payment = payment;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingContractPaymentDetails getPayment() {
        return this.payment;
    }

    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayment(BookingContractPaymentDetails payment) {
        this.payment = payment;
    }

    public BookingContract cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Whether the booking was cancelled.")
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContract cancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="When the booking was cancelled.")
    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCancelledOn() {
        return this.cancelledOn;
    }

    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
    }

    public BookingContract canceller(CancellerEnum canceller) {
        this.canceller = canceller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of entity that cancelled the booking.")
    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellerEnum getCanceller() {
        return this.canceller;
    }

    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanceller(CancellerEnum canceller) {
        this.canceller = canceller;
    }

    public BookingContract cancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason type.")
    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationTypeEnum getCancellationType() {
        return this.cancellationType;
    }

    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
    }

    public BookingContract cancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User identifier that cancelled the entity.")
    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancellerUserIdentifier() {
        return this.cancellerUserIdentifier;
    }

    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
    }

    public BookingContract cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for cancellation.")
    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public BookingContract fundsAddedToLedger(Boolean fundsAddedToLedger) {
        this.fundsAddedToLedger = fundsAddedToLedger;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the contract has been added to the ledger; rady for payout.")
    @JsonProperty(value="fundsAddedToLedger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsAddedToLedger() {
        return this.fundsAddedToLedger;
    }

    @JsonProperty(value="fundsAddedToLedger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsAddedToLedger(Boolean fundsAddedToLedger) {
        this.fundsAddedToLedger = fundsAddedToLedger;
    }

    public BookingContract fundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether a funds transfer request has been created for this booking.")
    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsProcessed() {
        return this.fundsProcessed;
    }

    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
    }

    public BookingContract refunds(List<Refund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public BookingContract addRefundsItem(Refund refundsItem) {
        if (this.refunds == null) {
            this.refunds = new ArrayList<Refund>();
        }
        this.refunds.add(refundsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.")
    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public BookingContract cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled completely by the traveller.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContract refundedCapturePrice(Moneys refundedCapturePrice) {
        this.refundedCapturePrice = refundedCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedCapturePrice() {
        return this.refundedCapturePrice;
    }

    @JsonProperty(value="refundedCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedCapturePrice(Moneys refundedCapturePrice) {
        this.refundedCapturePrice = refundedCapturePrice;
    }

    public BookingContract cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled completely by the supplier.")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContract cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the cancellation comes at no cost to the traveler.")
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContract cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.")
    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharges() {
        return this.cancellableWithPotentialCharges;
    }

    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    }

    public BookingContract lodging(BookingContractItem lodging) {
        this.lodging = lodging;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractItem getLodging() {
        return this.lodging;
    }

    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLodging(BookingContractItem lodging) {
        this.lodging = lodging;
    }

    public BookingContract refundedDisplayPrice(Moneys refundedDisplayPrice) {
        this.refundedDisplayPrice = refundedDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedDisplayPrice() {
        return this.refundedDisplayPrice;
    }

    @JsonProperty(value="refundedDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedDisplayPrice(Moneys refundedDisplayPrice) {
        this.refundedDisplayPrice = refundedDisplayPrice;
    }

    public BookingContract refundedInternalPrice(Moneys refundedInternalPrice) {
        this.refundedInternalPrice = refundedInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedInternalPrice() {
        return this.refundedInternalPrice;
    }

    @JsonProperty(value="refundedInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedInternalPrice(Moneys refundedInternalPrice) {
        this.refundedInternalPrice = refundedInternalPrice;
    }

    public BookingContract refundedSupplierPrice(Moneys refundedSupplierPrice) {
        this.refundedSupplierPrice = refundedSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedSupplierPrice() {
        return this.refundedSupplierPrice;
    }

    @JsonProperty(value="refundedSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedSupplierPrice(Moneys refundedSupplierPrice) {
        this.refundedSupplierPrice = refundedSupplierPrice;
    }

    public BookingContract refundedSourcePrice(Moneys refundedSourcePrice) {
        this.refundedSourcePrice = refundedSourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedSourcePrice() {
        return this.refundedSourcePrice;
    }

    @JsonProperty(value="refundedSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedSourcePrice(Moneys refundedSourcePrice) {
        this.refundedSourcePrice = refundedSourcePrice;
    }

    public BookingContract refundableDisplayPrice(Boolean refundableDisplayPrice) {
        this.refundableDisplayPrice = refundableDisplayPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="refundableDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefundableDisplayPrice() {
        return this.refundableDisplayPrice;
    }

    @JsonProperty(value="refundableDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundableDisplayPrice(Boolean refundableDisplayPrice) {
        this.refundableDisplayPrice = refundableDisplayPrice;
    }

    public BookingContract refundableInternalPrice(Boolean refundableInternalPrice) {
        this.refundableInternalPrice = refundableInternalPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="refundableInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefundableInternalPrice() {
        return this.refundableInternalPrice;
    }

    @JsonProperty(value="refundableInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundableInternalPrice(Boolean refundableInternalPrice) {
        this.refundableInternalPrice = refundableInternalPrice;
    }

    public BookingContract refundableSupplierPrice(Boolean refundableSupplierPrice) {
        this.refundableSupplierPrice = refundableSupplierPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="refundableSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefundableSupplierPrice() {
        return this.refundableSupplierPrice;
    }

    @JsonProperty(value="refundableSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundableSupplierPrice(Boolean refundableSupplierPrice) {
        this.refundableSupplierPrice = refundableSupplierPrice;
    }

    public BookingContract refundableSourcePrice(Boolean refundableSourcePrice) {
        this.refundableSourcePrice = refundableSourcePrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="refundableSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefundableSourcePrice() {
        return this.refundableSourcePrice;
    }

    @JsonProperty(value="refundableSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundableSourcePrice(Boolean refundableSourcePrice) {
        this.refundableSourcePrice = refundableSourcePrice;
    }

    public BookingContract refundableCapturePrice(Boolean refundableCapturePrice) {
        this.refundableCapturePrice = refundableCapturePrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="refundableCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefundableCapturePrice() {
        return this.refundableCapturePrice;
    }

    @JsonProperty(value="refundableCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundableCapturePrice(Boolean refundableCapturePrice) {
        this.refundableCapturePrice = refundableCapturePrice;
    }

    public BookingContract totalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of tokens minted on this contract.")
    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalTokensEarned() {
        return this.totalTokensEarned;
    }

    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
    }

    public BookingContract lodgingItinerary(Itinerary lodgingItinerary) {
        this.lodgingItinerary = lodgingItinerary;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="lodgingItinerary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Itinerary getLodgingItinerary() {
        return this.lodgingItinerary;
    }

    @JsonProperty(value="lodgingItinerary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLodgingItinerary(Itinerary lodgingItinerary) {
        this.lodgingItinerary = lodgingItinerary;
    }

    public BookingContract totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public BookingContract totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public BookingContract totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public BookingContract totalSourcePrice(Moneys totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSourcePrice() {
        return this.totalSourcePrice;
    }

    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePrice(Moneys totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
    }

    public BookingContract totalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public BookingContract totalDisplayPriceAfterRefund(Moneys totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPriceAfterRefund() {
        return this.totalDisplayPriceAfterRefund;
    }

    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPriceAfterRefund(Moneys totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    }

    public BookingContract totalInternalPriceAfterRefund(Moneys totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPriceAfterRefund() {
        return this.totalInternalPriceAfterRefund;
    }

    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPriceAfterRefund(Moneys totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    }

    public BookingContract totalSupplierPriceAfterRefund(Moneys totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPriceAfterRefund() {
        return this.totalSupplierPriceAfterRefund;
    }

    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPriceAfterRefund(Moneys totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    }

    public BookingContract totalSourcePriceAfterRefund(Moneys totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSourcePriceAfterRefund() {
        return this.totalSourcePriceAfterRefund;
    }

    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePriceAfterRefund(Moneys totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    }

    public BookingContract totalCapturePriceAfterRefund(Moneys totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePriceAfterRefund() {
        return this.totalCapturePriceAfterRefund;
    }

    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePriceAfterRefund(Moneys totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContract bookingContract = (BookingContract)o;
        return Objects.equals(this.id, bookingContract.id) && Objects.equals(this.createdDate, bookingContract.createdDate) && Objects.equals(this.lastUpdate, bookingContract.lastUpdate) && Objects.equals(this.version, bookingContract.version) && Objects.equals(this.ipAddress, bookingContract.ipAddress) && Objects.equals(this.traceId, bookingContract.traceId) && Objects.equals(this.sourceUrl, bookingContract.sourceUrl) && Objects.equals(this.identifier, bookingContract.identifier) && Objects.equals(this.supplierIdentifier, bookingContract.supplierIdentifier) && Objects.equals(this.supplierName, bookingContract.supplierName) && Objects.equals(this.displayPriceQuote, bookingContract.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, bookingContract.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, bookingContract.internalPriceQuote) && Objects.equals(this.capturePriceQuote, bookingContract.capturePriceQuote) && Objects.equals(this.itemList, bookingContract.itemList) && Objects.equals(this.externalSupplierIdentifier, bookingContract.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, bookingContract.externalSupplierBookingCode) && Objects.equals(this.payment, bookingContract.payment) && Objects.equals(this.cancelled, bookingContract.cancelled) && Objects.equals(this.cancelledOn, bookingContract.cancelledOn) && Objects.equals((Object)this.canceller, (Object)bookingContract.canceller) && Objects.equals((Object)this.cancellationType, (Object)bookingContract.cancellationType) && Objects.equals(this.cancellerUserIdentifier, bookingContract.cancellerUserIdentifier) && Objects.equals(this.cancelReason, bookingContract.cancelReason) && Objects.equals(this.fundsAddedToLedger, bookingContract.fundsAddedToLedger) && Objects.equals(this.fundsProcessed, bookingContract.fundsProcessed) && Objects.equals(this.refunds, bookingContract.refunds) && Objects.equals(this.cancellableByTraveler, bookingContract.cancellableByTraveler) && Objects.equals(this.refundedCapturePrice, bookingContract.refundedCapturePrice) && Objects.equals(this.cancellableBySupplier, bookingContract.cancellableBySupplier) && Objects.equals(this.cancellableWithNoCharges, bookingContract.cancellableWithNoCharges) && Objects.equals(this.cancellableWithPotentialCharges, bookingContract.cancellableWithPotentialCharges) && Objects.equals(this.lodging, bookingContract.lodging) && Objects.equals(this.refundedDisplayPrice, bookingContract.refundedDisplayPrice) && Objects.equals(this.refundedInternalPrice, bookingContract.refundedInternalPrice) && Objects.equals(this.refundedSupplierPrice, bookingContract.refundedSupplierPrice) && Objects.equals(this.refundedSourcePrice, bookingContract.refundedSourcePrice) && Objects.equals(this.refundableDisplayPrice, bookingContract.refundableDisplayPrice) && Objects.equals(this.refundableInternalPrice, bookingContract.refundableInternalPrice) && Objects.equals(this.refundableSupplierPrice, bookingContract.refundableSupplierPrice) && Objects.equals(this.refundableSourcePrice, bookingContract.refundableSourcePrice) && Objects.equals(this.refundableCapturePrice, bookingContract.refundableCapturePrice) && Objects.equals(this.totalTokensEarned, bookingContract.totalTokensEarned) && Objects.equals(this.lodgingItinerary, bookingContract.lodgingItinerary) && Objects.equals(this.totalDisplayPrice, bookingContract.totalDisplayPrice) && Objects.equals(this.totalInternalPrice, bookingContract.totalInternalPrice) && Objects.equals(this.totalSupplierPrice, bookingContract.totalSupplierPrice) && Objects.equals(this.totalSourcePrice, bookingContract.totalSourcePrice) && Objects.equals(this.totalCapturePrice, bookingContract.totalCapturePrice) && Objects.equals(this.totalDisplayPriceAfterRefund, bookingContract.totalDisplayPriceAfterRefund) && Objects.equals(this.totalInternalPriceAfterRefund, bookingContract.totalInternalPriceAfterRefund) && Objects.equals(this.totalSupplierPriceAfterRefund, bookingContract.totalSupplierPriceAfterRefund) && Objects.equals(this.totalSourcePriceAfterRefund, bookingContract.totalSourcePriceAfterRefund) && Objects.equals(this.totalCapturePriceAfterRefund, bookingContract.totalCapturePriceAfterRefund);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.payment, this.cancelled, this.cancelledOn, this.canceller, this.cancellationType, this.cancellerUserIdentifier, this.cancelReason, this.fundsAddedToLedger, this.fundsProcessed, this.refunds, this.cancellableByTraveler, this.refundedCapturePrice, this.cancellableBySupplier, this.cancellableWithNoCharges, this.cancellableWithPotentialCharges, this.lodging, this.refundedDisplayPrice, this.refundedInternalPrice, this.refundedSupplierPrice, this.refundedSourcePrice, this.refundableDisplayPrice, this.refundableInternalPrice, this.refundableSupplierPrice, this.refundableSourcePrice, this.refundableCapturePrice, this.totalTokensEarned, this.lodgingItinerary, this.totalDisplayPrice, this.totalInternalPrice, this.totalSupplierPrice, this.totalSourcePrice, this.totalCapturePrice, this.totalDisplayPriceAfterRefund, this.totalInternalPriceAfterRefund, this.totalSupplierPriceAfterRefund, this.totalSourcePriceAfterRefund, this.totalCapturePriceAfterRefund});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContract {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    cancelledOn: ").append(this.toIndentedString(this.cancelledOn)).append("\n");
        sb.append("    canceller: ").append(this.toIndentedString((Object)this.canceller)).append("\n");
        sb.append("    cancellationType: ").append(this.toIndentedString((Object)this.cancellationType)).append("\n");
        sb.append("    cancellerUserIdentifier: ").append(this.toIndentedString(this.cancellerUserIdentifier)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    fundsAddedToLedger: ").append(this.toIndentedString(this.fundsAddedToLedger)).append("\n");
        sb.append("    fundsProcessed: ").append(this.toIndentedString(this.fundsProcessed)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    refundedCapturePrice: ").append(this.toIndentedString(this.refundedCapturePrice)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    cancellableWithPotentialCharges: ").append(this.toIndentedString(this.cancellableWithPotentialCharges)).append("\n");
        sb.append("    lodging: ").append(this.toIndentedString(this.lodging)).append("\n");
        sb.append("    refundedDisplayPrice: ").append(this.toIndentedString(this.refundedDisplayPrice)).append("\n");
        sb.append("    refundedInternalPrice: ").append(this.toIndentedString(this.refundedInternalPrice)).append("\n");
        sb.append("    refundedSupplierPrice: ").append(this.toIndentedString(this.refundedSupplierPrice)).append("\n");
        sb.append("    refundedSourcePrice: ").append(this.toIndentedString(this.refundedSourcePrice)).append("\n");
        sb.append("    refundableDisplayPrice: ").append(this.toIndentedString(this.refundableDisplayPrice)).append("\n");
        sb.append("    refundableInternalPrice: ").append(this.toIndentedString(this.refundableInternalPrice)).append("\n");
        sb.append("    refundableSupplierPrice: ").append(this.toIndentedString(this.refundableSupplierPrice)).append("\n");
        sb.append("    refundableSourcePrice: ").append(this.toIndentedString(this.refundableSourcePrice)).append("\n");
        sb.append("    refundableCapturePrice: ").append(this.toIndentedString(this.refundableCapturePrice)).append("\n");
        sb.append("    totalTokensEarned: ").append(this.toIndentedString(this.totalTokensEarned)).append("\n");
        sb.append("    lodgingItinerary: ").append(this.toIndentedString(this.lodgingItinerary)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalSourcePrice: ").append(this.toIndentedString(this.totalSourcePrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    totalDisplayPriceAfterRefund: ").append(this.toIndentedString(this.totalDisplayPriceAfterRefund)).append("\n");
        sb.append("    totalInternalPriceAfterRefund: ").append(this.toIndentedString(this.totalInternalPriceAfterRefund)).append("\n");
        sb.append("    totalSupplierPriceAfterRefund: ").append(this.toIndentedString(this.totalSupplierPriceAfterRefund)).append("\n");
        sb.append("    totalSourcePriceAfterRefund: ").append(this.toIndentedString(this.totalSourcePriceAfterRefund)).append("\n");
        sb.append("    totalCapturePriceAfterRefund: ").append(this.toIndentedString(this.totalCapturePriceAfterRefund)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER"),
        ACQUIRER("ACQUIRER"),
        ADMINISTRATOR("ADMINISTRATOR");

        private String value;

        private CancellerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerEnum fromValue(String value) {
            for (CancellerEnum b : CancellerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationTypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private CancellationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationTypeEnum fromValue(String value) {
            for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

