/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.NmiCardholder;
import io.trippay.sdk.payment.acquiring.model.NmiCreditCardToken;
import io.trippay.sdk.payment.acquiring.model.RawSupplierContract;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"acquirerIdentifier", "affiliateAccountIdentifier", "affiliateAccountIdentifierType", "displayCurrency", "sourceUrl", "traceId", "contract", "token", "cardholder"})
public class CreateNmiSaleRequest {
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    private String acquirerIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
    private UUID affiliateAccountIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
    private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    private RawSupplierContract contract;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private NmiCreditCardToken token;
    public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
    private NmiCardholder cardholder;

    public CreateNmiSaleRequest acquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="user-1", required=true, value="Acquirer identifier to use for processing")
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public CreateNmiSaleRequest affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="affiliate account making the request")
    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAffiliateAccountIdentifier() {
        return this.affiliateAccountIdentifier;
    }

    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    }

    public CreateNmiSaleRequest affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Type of identifier this is")
    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
        return this.affiliateAccountIdentifierType;
    }

    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    }

    public CreateNmiSaleRequest displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired quote")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public CreateNmiSaleRequest sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateNmiSaleRequest traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="integrator-booking-code-1", value="Integrator can choose to include a unique identifier to help identify the collection of bookings")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public CreateNmiSaleRequest contract(RawSupplierContract contract) {
        this.contract = contract;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RawSupplierContract getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContract(RawSupplierContract contract) {
        this.contract = contract;
    }

    public CreateNmiSaleRequest token(NmiCreditCardToken token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NmiCreditCardToken getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setToken(NmiCreditCardToken token) {
        this.token = token;
    }

    public CreateNmiSaleRequest cardholder(NmiCardholder cardholder) {
        this.cardholder = cardholder;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="cardholder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NmiCardholder getCardholder() {
        return this.cardholder;
    }

    @JsonProperty(value="cardholder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCardholder(NmiCardholder cardholder) {
        this.cardholder = cardholder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNmiSaleRequest createNmiSaleRequest = (CreateNmiSaleRequest)o;
        return Objects.equals(this.acquirerIdentifier, createNmiSaleRequest.acquirerIdentifier) && Objects.equals(this.affiliateAccountIdentifier, createNmiSaleRequest.affiliateAccountIdentifier) && Objects.equals((Object)this.affiliateAccountIdentifierType, (Object)createNmiSaleRequest.affiliateAccountIdentifierType) && Objects.equals(this.displayCurrency, createNmiSaleRequest.displayCurrency) && Objects.equals(this.sourceUrl, createNmiSaleRequest.sourceUrl) && Objects.equals(this.traceId, createNmiSaleRequest.traceId) && Objects.equals(this.contract, createNmiSaleRequest.contract) && Objects.equals(this.token, createNmiSaleRequest.token) && Objects.equals(this.cardholder, createNmiSaleRequest.cardholder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquirerIdentifier, this.affiliateAccountIdentifier, this.affiliateAccountIdentifierType, this.displayCurrency, this.sourceUrl, this.traceId, this.contract, this.token, this.cardholder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateNmiSaleRequest {\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifier: ").append(this.toIndentedString(this.affiliateAccountIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifierType: ").append(this.toIndentedString((Object)this.affiliateAccountIdentifierType)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    cardholder: ").append(this.toIndentedString(this.cardholder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AffiliateAccountIdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private AffiliateAccountIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
            for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

