/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.Moneys;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="In case of LODGING, include daily rates")
@JsonPropertyOrder(value={"date", "price"})
public class RawDailyRate {
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_PRICE = "price";
    private Moneys price;

    public RawDailyRate date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Mon Aug 24 07:00:00 ICT 2020", required=true, value="The date this rate is applicable for.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public RawDailyRate price(Moneys price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(Moneys price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawDailyRate rawDailyRate = (RawDailyRate)o;
        return Objects.equals(this.date, rawDailyRate.date) && Objects.equals(this.price, rawDailyRate.price);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.price);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawDailyRate {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

