/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.Moneys;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Refund objects allow you to refund a charge that has previously been created but not yet refunded. Funds will be refunded to the credit or debit card that was originally charged.")
@JsonPropertyOrder(value={"identifier", "acquirerRefundIdentifier", "requestedByIdentifier", "refund", "created", "description", "reasonType", "statusType", "requestType", "requestStatus", "requestResponse", "receiptUrl"})
public class Refund {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER = "acquirerRefundIdentifier";
    private String acquirerRefundIdentifier;
    public static final String JSON_PROPERTY_REQUESTED_BY_IDENTIFIER = "requestedByIdentifier";
    private String requestedByIdentifier;
    public static final String JSON_PROPERTY_REFUND = "refund";
    private Moneys refund;
    public static final String JSON_PROPERTY_CREATED = "created";
    private LocalDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
    private ReasonTypeEnum reasonType;
    public static final String JSON_PROPERTY_STATUS_TYPE = "statusType";
    private StatusTypeEnum statusType;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    private RequestTypeEnum requestType;
    public static final String JSON_PROPERTY_REQUEST_STATUS = "requestStatus";
    private RequestStatusEnum requestStatus;
    public static final String JSON_PROPERTY_REQUEST_RESPONSE = "requestResponse";
    private String requestResponse;
    public static final String JSON_PROPERTY_RECEIPT_URL = "receiptUrl";
    private String receiptUrl;

    public Refund identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="refund-1", required=true, value="A unique identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Refund acquirerRefundIdentifier(String acquirerRefundIdentifier) {
        this.acquirerRefundIdentifier = acquirerRefundIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="r-123456", value="The acquirer refund identifier. Will get attached once it comes in on the webhook.")
    @JsonProperty(value="acquirerRefundIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerRefundIdentifier() {
        return this.acquirerRefundIdentifier;
    }

    @JsonProperty(value="acquirerRefundIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerRefundIdentifier(String acquirerRefundIdentifier) {
        this.acquirerRefundIdentifier = acquirerRefundIdentifier;
    }

    public Refund requestedByIdentifier(String requestedByIdentifier) {
        this.requestedByIdentifier = requestedByIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user-1", value="The SSO person / entity that requested the refund.")
    @JsonProperty(value="requestedByIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestedByIdentifier() {
        return this.requestedByIdentifier;
    }

    @JsonProperty(value="requestedByIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedByIdentifier(String requestedByIdentifier) {
        this.requestedByIdentifier = requestedByIdentifier;
    }

    public Refund refund(Moneys refund) {
        this.refund = refund;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getRefund() {
        return this.refund;
    }

    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefund(Moneys refund) {
        this.refund = refund;
    }

    public Refund created(LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="When the amount was refunded")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public Refund description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Customer made a mistake", required=true, value="A description of the refund that can be displayed to booker")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Refund reasonType(ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="DUPLICATE", required=true, value="A description of the refund that can be displayed to booker")
    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReasonTypeEnum getReasonType() {
        return this.reasonType;
    }

    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReasonType(ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
    }

    public Refund statusType(StatusTypeEnum statusType) {
        this.statusType = statusType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="SUCCEEDED", required=true, value="Status of the refund")
    @JsonProperty(value="statusType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    @JsonProperty(value="statusType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatusType(StatusTypeEnum statusType) {
        this.statusType = statusType;
    }

    public Refund requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="BY_ADMIN", required=true, value="The entity making the refund request")
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public Refund requestStatus(RequestStatusEnum requestStatus) {
        this.requestStatus = requestStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="APPROVED", required=true, value="Status of the refund request")
    @JsonProperty(value="requestStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RequestStatusEnum getRequestStatus() {
        return this.requestStatus;
    }

    @JsonProperty(value="requestStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestStatus(RequestStatusEnum requestStatus) {
        this.requestStatus = requestStatus;
    }

    public Refund requestResponse(String requestResponse) {
        this.requestResponse = requestResponse;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="We have rejected your request. Your cancellation policy does not warrant a manual refund.", required=true, value="Admin may choose to respond to the refund request made by the hotel")
    @JsonProperty(value="requestResponse")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRequestResponse() {
        return this.requestResponse;
    }

    @JsonProperty(value="requestResponse")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestResponse(String requestResponse) {
        this.requestResponse = requestResponse;
    }

    public Refund receiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://pay.stripe.com/receipts/payment/CAcaFwoVYWNjdF8xSXcxazVBQ3F2UW9nN1IxKIPqo54GMgbHKn45YQY6LBbCZ62655YzamuWDVeWAaw7uApCrxewxjSsZX4C9Lef5jY9JeYFrOVx3IaI", value="This is the receipt url that contains a friendly web confirmation page. Comes in on the webhook.")
    @JsonProperty(value="receiptUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    @JsonProperty(value="receiptUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.identifier, refund.identifier) && Objects.equals(this.acquirerRefundIdentifier, refund.acquirerRefundIdentifier) && Objects.equals(this.requestedByIdentifier, refund.requestedByIdentifier) && Objects.equals(this.refund, refund.refund) && Objects.equals(this.created, refund.created) && Objects.equals(this.description, refund.description) && Objects.equals((Object)this.reasonType, (Object)refund.reasonType) && Objects.equals((Object)this.statusType, (Object)refund.statusType) && Objects.equals((Object)this.requestType, (Object)refund.requestType) && Objects.equals((Object)this.requestStatus, (Object)refund.requestStatus) && Objects.equals(this.requestResponse, refund.requestResponse) && Objects.equals(this.receiptUrl, refund.receiptUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.acquirerRefundIdentifier, this.requestedByIdentifier, this.refund, this.created, this.description, this.reasonType, this.statusType, this.requestType, this.requestStatus, this.requestResponse, this.receiptUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    acquirerRefundIdentifier: ").append(this.toIndentedString(this.acquirerRefundIdentifier)).append("\n");
        sb.append("    requestedByIdentifier: ").append(this.toIndentedString(this.requestedByIdentifier)).append("\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reasonType: ").append(this.toIndentedString((Object)this.reasonType)).append("\n");
        sb.append("    statusType: ").append(this.toIndentedString((Object)this.statusType)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    requestStatus: ").append(this.toIndentedString((Object)this.requestStatus)).append("\n");
        sb.append("    requestResponse: ").append(this.toIndentedString(this.requestResponse)).append("\n");
        sb.append("    receiptUrl: ").append(this.toIndentedString(this.receiptUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReasonTypeEnum {
        DUPLICATE("DUPLICATE"),
        FRAUDULENT("FRAUDULENT"),
        REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
        GUEST_COMPLAINT("GUEST_COMPLAINT"),
        GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
        GUEST_SICK("GUEST_SICK"),
        OVERBOOKING("OVERBOOKING"),
        EMERGENCY("EMERGENCY"),
        FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
        DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
        OTHER("OTHER"),
        EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

        private String value;

        private ReasonTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonTypeEnum fromValue(String value) {
            for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusTypeEnum {
        PENDING("PENDING"),
        SUCCEEDED("SUCCEEDED"),
        CANCELED("CANCELED"),
        REQUIRES_ACTION("REQUIRES_ACTION"),
        FAILED("FAILED");

        private String value;

        private StatusTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusTypeEnum fromValue(String value) {
            for (StatusTypeEnum b : StatusTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestTypeEnum {
        SUPPLIER("BY_SUPPLIER"),
        ADMIN("BY_ADMIN"),
        STRIPE("BY_STRIPE"),
        SYSTEM("BY_SYSTEM");

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestStatusEnum {
        PENDING("PENDING"),
        APPROVED("APPROVED"),
        REJECTED("REJECTED");

        private String value;

        private RequestStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestStatusEnum fromValue(String value) {
            for (RequestStatusEnum b : RequestStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

