/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.Moneys;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Beneficiary is a registered account with rights to compensation within a booking.
 */
@ApiModel(description = "Beneficiary is a registered account with rights to compensation within a booking.")
@JsonPropertyOrder({
  Beneficiary.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  Beneficiary.JSON_PROPERTY_ACCOUNT_NAME,
  Beneficiary.JSON_PROPERTY_ACCOUNT_EMAIL,
  Beneficiary.JSON_PROPERTY_ACCOUNT_URL,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY,
  Beneficiary.JSON_PROPERTY_TYPE,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_PRICE_AFTER_REFUND,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_PRICE_AFTER_REFUND,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_PRICE_AFTER_REFUND,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_PRICE_AFTER_REFUND,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_PRICE_AFTER_REFUND
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:19:35.232706929+07:00[Asia/Bangkok]")
public class Beneficiary {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private String accountIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
  private String accountEmail;

  public static final String JSON_PROPERTY_ACCOUNT_URL = "accountUrl";
  private String accountUrl;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
  private Moneys amountDueInSourceCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
  private Moneys amountDueInDisplayCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
  private Moneys amountDueInSupplierCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
  private Moneys amountDueInInternalCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
  private Moneys amountDueInCaptureCurrency;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    TRIP_PAY("TRIP_PAY"),
    
    SALE("SALE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_PRICE_AFTER_REFUND = "amountDueInSourcePriceAfterRefund";
  private Moneys amountDueInSourcePriceAfterRefund;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_PRICE_AFTER_REFUND = "amountDueInDisplayPriceAfterRefund";
  private Moneys amountDueInDisplayPriceAfterRefund;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_PRICE_AFTER_REFUND = "amountDueInSupplierPriceAfterRefund";
  private Moneys amountDueInSupplierPriceAfterRefund;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_PRICE_AFTER_REFUND = "amountDueInInternalPriceAfterRefund";
  private Moneys amountDueInInternalPriceAfterRefund;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_PRICE_AFTER_REFUND = "amountDueInCapturePriceAfterRefund";
  private Moneys amountDueInCapturePriceAfterRefund;

  public Beneficiary() { 
  }

  public Beneficiary accountIdentifier(String accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * accountIdentifier of beneficiary that can map to an account with us
   * @return accountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "account-1", required = true, value = "accountIdentifier of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(String accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public Beneficiary accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * accountName of beneficiary that can map to an account with us
   * @return accountName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Account 1", required = true, value = "accountName of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountName() {
    return accountName;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public Beneficiary accountEmail(String accountEmail) {
    
    this.accountEmail = accountEmail;
    return this;
  }

   /**
   * accountEmail of beneficiary that can map to an account with us
   * @return accountEmail
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "account@one.com", required = true, value = "accountEmail of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountEmail() {
    return accountEmail;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountEmail(String accountEmail) {
    this.accountEmail = accountEmail;
  }


  public Beneficiary accountUrl(String accountUrl) {
    
    this.accountUrl = accountUrl;
    return this;
  }

   /**
   * accountUrl of beneficiary that can map to an account with us
   * @return accountUrl
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://some.url", required = true, value = "accountUrl of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountUrl() {
    return accountUrl;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountUrl(String accountUrl) {
    this.accountUrl = accountUrl;
  }


  public Beneficiary amountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
    
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    return this;
  }

   /**
   * Get amountDueInSourceCurrency
   * @return amountDueInSourceCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInSourceCurrency() {
    return amountDueInSourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
  }


  public Beneficiary amountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
    
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    return this;
  }

   /**
   * Get amountDueInDisplayCurrency
   * @return amountDueInDisplayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInDisplayCurrency() {
    return amountDueInDisplayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
  }


  public Beneficiary amountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
    
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    return this;
  }

   /**
   * Get amountDueInSupplierCurrency
   * @return amountDueInSupplierCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInSupplierCurrency() {
    return amountDueInSupplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
  }


  public Beneficiary amountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
    
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    return this;
  }

   /**
   * Get amountDueInInternalCurrency
   * @return amountDueInInternalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInInternalCurrency() {
    return amountDueInInternalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
  }


  public Beneficiary amountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
    
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    return this;
  }

   /**
   * Get amountDueInCaptureCurrency
   * @return amountDueInCaptureCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInCaptureCurrency() {
    return amountDueInCaptureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
  }


  public Beneficiary type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "The type of beneficiary payment.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Beneficiary amountDueInSourcePriceAfterRefund(Moneys amountDueInSourcePriceAfterRefund) {
    
    this.amountDueInSourcePriceAfterRefund = amountDueInSourcePriceAfterRefund;
    return this;
  }

   /**
   * Get amountDueInSourcePriceAfterRefund
   * @return amountDueInSourcePriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getAmountDueInSourcePriceAfterRefund() {
    return amountDueInSourcePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDueInSourcePriceAfterRefund(Moneys amountDueInSourcePriceAfterRefund) {
    this.amountDueInSourcePriceAfterRefund = amountDueInSourcePriceAfterRefund;
  }


  public Beneficiary amountDueInDisplayPriceAfterRefund(Moneys amountDueInDisplayPriceAfterRefund) {
    
    this.amountDueInDisplayPriceAfterRefund = amountDueInDisplayPriceAfterRefund;
    return this;
  }

   /**
   * Get amountDueInDisplayPriceAfterRefund
   * @return amountDueInDisplayPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getAmountDueInDisplayPriceAfterRefund() {
    return amountDueInDisplayPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDueInDisplayPriceAfterRefund(Moneys amountDueInDisplayPriceAfterRefund) {
    this.amountDueInDisplayPriceAfterRefund = amountDueInDisplayPriceAfterRefund;
  }


  public Beneficiary amountDueInSupplierPriceAfterRefund(Moneys amountDueInSupplierPriceAfterRefund) {
    
    this.amountDueInSupplierPriceAfterRefund = amountDueInSupplierPriceAfterRefund;
    return this;
  }

   /**
   * Get amountDueInSupplierPriceAfterRefund
   * @return amountDueInSupplierPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getAmountDueInSupplierPriceAfterRefund() {
    return amountDueInSupplierPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDueInSupplierPriceAfterRefund(Moneys amountDueInSupplierPriceAfterRefund) {
    this.amountDueInSupplierPriceAfterRefund = amountDueInSupplierPriceAfterRefund;
  }


  public Beneficiary amountDueInInternalPriceAfterRefund(Moneys amountDueInInternalPriceAfterRefund) {
    
    this.amountDueInInternalPriceAfterRefund = amountDueInInternalPriceAfterRefund;
    return this;
  }

   /**
   * Get amountDueInInternalPriceAfterRefund
   * @return amountDueInInternalPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getAmountDueInInternalPriceAfterRefund() {
    return amountDueInInternalPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDueInInternalPriceAfterRefund(Moneys amountDueInInternalPriceAfterRefund) {
    this.amountDueInInternalPriceAfterRefund = amountDueInInternalPriceAfterRefund;
  }


  public Beneficiary amountDueInCapturePriceAfterRefund(Moneys amountDueInCapturePriceAfterRefund) {
    
    this.amountDueInCapturePriceAfterRefund = amountDueInCapturePriceAfterRefund;
    return this;
  }

   /**
   * Get amountDueInCapturePriceAfterRefund
   * @return amountDueInCapturePriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getAmountDueInCapturePriceAfterRefund() {
    return amountDueInCapturePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDueInCapturePriceAfterRefund(Moneys amountDueInCapturePriceAfterRefund) {
    this.amountDueInCapturePriceAfterRefund = amountDueInCapturePriceAfterRefund;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Beneficiary beneficiary = (Beneficiary) o;
    return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) &&
        Objects.equals(this.accountName, beneficiary.accountName) &&
        Objects.equals(this.accountEmail, beneficiary.accountEmail) &&
        Objects.equals(this.accountUrl, beneficiary.accountUrl) &&
        Objects.equals(this.amountDueInSourceCurrency, beneficiary.amountDueInSourceCurrency) &&
        Objects.equals(this.amountDueInDisplayCurrency, beneficiary.amountDueInDisplayCurrency) &&
        Objects.equals(this.amountDueInSupplierCurrency, beneficiary.amountDueInSupplierCurrency) &&
        Objects.equals(this.amountDueInInternalCurrency, beneficiary.amountDueInInternalCurrency) &&
        Objects.equals(this.amountDueInCaptureCurrency, beneficiary.amountDueInCaptureCurrency) &&
        Objects.equals(this.type, beneficiary.type) &&
        Objects.equals(this.amountDueInSourcePriceAfterRefund, beneficiary.amountDueInSourcePriceAfterRefund) &&
        Objects.equals(this.amountDueInDisplayPriceAfterRefund, beneficiary.amountDueInDisplayPriceAfterRefund) &&
        Objects.equals(this.amountDueInSupplierPriceAfterRefund, beneficiary.amountDueInSupplierPriceAfterRefund) &&
        Objects.equals(this.amountDueInInternalPriceAfterRefund, beneficiary.amountDueInInternalPriceAfterRefund) &&
        Objects.equals(this.amountDueInCapturePriceAfterRefund, beneficiary.amountDueInCapturePriceAfterRefund);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentifier, accountName, accountEmail, accountUrl, amountDueInSourceCurrency, amountDueInDisplayCurrency, amountDueInSupplierCurrency, amountDueInInternalCurrency, amountDueInCaptureCurrency, type, amountDueInSourcePriceAfterRefund, amountDueInDisplayPriceAfterRefund, amountDueInSupplierPriceAfterRefund, amountDueInInternalPriceAfterRefund, amountDueInCapturePriceAfterRefund);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Beneficiary {\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    accountEmail: ").append(toIndentedString(accountEmail)).append("\n");
    sb.append("    accountUrl: ").append(toIndentedString(accountUrl)).append("\n");
    sb.append("    amountDueInSourceCurrency: ").append(toIndentedString(amountDueInSourceCurrency)).append("\n");
    sb.append("    amountDueInDisplayCurrency: ").append(toIndentedString(amountDueInDisplayCurrency)).append("\n");
    sb.append("    amountDueInSupplierCurrency: ").append(toIndentedString(amountDueInSupplierCurrency)).append("\n");
    sb.append("    amountDueInInternalCurrency: ").append(toIndentedString(amountDueInInternalCurrency)).append("\n");
    sb.append("    amountDueInCaptureCurrency: ").append(toIndentedString(amountDueInCaptureCurrency)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    amountDueInSourcePriceAfterRefund: ").append(toIndentedString(amountDueInSourcePriceAfterRefund)).append("\n");
    sb.append("    amountDueInDisplayPriceAfterRefund: ").append(toIndentedString(amountDueInDisplayPriceAfterRefund)).append("\n");
    sb.append("    amountDueInSupplierPriceAfterRefund: ").append(toIndentedString(amountDueInSupplierPriceAfterRefund)).append("\n");
    sb.append("    amountDueInInternalPriceAfterRefund: ").append(toIndentedString(amountDueInInternalPriceAfterRefund)).append("\n");
    sb.append("    amountDueInCapturePriceAfterRefund: ").append(toIndentedString(amountDueInCapturePriceAfterRefund)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

