/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.trippay.sdk.payment.acquiring.model.Moneys;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * In case of LODGING, include daily rates
 */
@ApiModel(description = "In case of LODGING, include daily rates")
@JsonPropertyOrder({
  PricedDailyRate.JSON_PROPERTY_DATE,
  PricedDailyRate.JSON_PROPERTY_PRICE,
  PricedDailyRate.JSON_PROPERTY_DISPLAY_PRICE,
  PricedDailyRate.JSON_PROPERTY_SUPPLIER_PRICE,
  PricedDailyRate.JSON_PROPERTY_INTERNAL_PRICE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:19:35.232706929+07:00[Asia/Bangkok]")
public class PricedDailyRate {
  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_PRICE = "price";
  private Moneys price;

  public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
  private Moneys displayPrice;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
  private Moneys supplierPrice;

  public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
  private Moneys internalPrice;

  public PricedDailyRate() { 
  }

  public PricedDailyRate date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * The date this rate is applicable for.
   * @return date
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Mon Aug 24 07:00:00 ICT 2020", required = true, value = "The date this rate is applicable for.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public PricedDailyRate price(Moneys price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(Moneys price) {
    this.price = price;
  }


  public PricedDailyRate displayPrice(Moneys displayPrice) {
    
    this.displayPrice = displayPrice;
    return this;
  }

   /**
   * Get displayPrice
   * @return displayPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getDisplayPrice() {
    return displayPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPrice(Moneys displayPrice) {
    this.displayPrice = displayPrice;
  }


  public PricedDailyRate supplierPrice(Moneys supplierPrice) {
    
    this.supplierPrice = supplierPrice;
    return this;
  }

   /**
   * Get supplierPrice
   * @return supplierPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getSupplierPrice() {
    return supplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPrice(Moneys supplierPrice) {
    this.supplierPrice = supplierPrice;
  }


  public PricedDailyRate internalPrice(Moneys internalPrice) {
    
    this.internalPrice = internalPrice;
    return this;
  }

   /**
   * Get internalPrice
   * @return internalPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getInternalPrice() {
    return internalPrice;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPrice(Moneys internalPrice) {
    this.internalPrice = internalPrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PricedDailyRate pricedDailyRate = (PricedDailyRate) o;
    return Objects.equals(this.date, pricedDailyRate.date) &&
        Objects.equals(this.price, pricedDailyRate.price) &&
        Objects.equals(this.displayPrice, pricedDailyRate.displayPrice) &&
        Objects.equals(this.supplierPrice, pricedDailyRate.supplierPrice) &&
        Objects.equals(this.internalPrice, pricedDailyRate.internalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, price, displayPrice, supplierPrice, internalPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PricedDailyRate {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    displayPrice: ").append(toIndentedString(displayPrice)).append("\n");
    sb.append("    supplierPrice: ").append(toIndentedString(supplierPrice)).append("\n");
    sb.append("    internalPrice: ").append(toIndentedString(internalPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

