/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.acquiring.model.Beneficiary;
import io.trippay.sdk.payment.acquiring.model.BookingContractItem;
import io.trippay.sdk.payment.acquiring.model.BookingContractPaymentDetails;
import io.trippay.sdk.payment.acquiring.model.Itinerary;
import io.trippay.sdk.payment.acquiring.model.Quote;
import io.trippay.sdk.payment.acquiring.model.Refund;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "externalSupplierIdentifier", "externalSupplierBookingCode", "payment", "cancelled", "cancelledOn", "canceller", "cancellationType", "cancellerUserIdentifier", "cancelReason", "fundsAddedToLedger", "fundsProcessed", "refunds", "sourceCurrency", "displayCurrency", "supplierCurrency", "internalCurrency", "captureCurrency", "sourceAmount", "displayAmount", "supplierAmount", "internalAmount", "captureAmount", "sourceAmountRefundModifier", "displayAmountRefundModifier", "supplierAmountRefundModifier", "internalAmountRefundModifier", "captureAmountRefundModifier", "netCaptureAmount", "cancellableByTraveler", "cancellableBySupplier", "netSupplierAmount", "cancellableWithNoCharges", "cancellableWithPotentialCharges", "lodging", "totalTokensEarned", "lodgingItinerary", "totalFundsGroupedByBeneficiary", "netSourceAmount", "netDisplayAmount", "netInternalAmount", "refundable", "refunded"})
public class BookingContract {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private Quote displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private Quote supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private Quote internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private Quote capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<BookingContractItem> itemList = new ArrayList<BookingContractItem>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_PAYMENT = "payment";
    private BookingContractPaymentDetails payment;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled;
    public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
    private LocalDateTime cancelledOn;
    public static final String JSON_PROPERTY_CANCELLER = "canceller";
    private CancellerEnum canceller;
    public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
    private CancellationTypeEnum cancellationType;
    public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
    private String cancellerUserIdentifier;
    public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
    private String cancelReason;
    public static final String JSON_PROPERTY_FUNDS_ADDED_TO_LEDGER = "fundsAddedToLedger";
    private Boolean fundsAddedToLedger;
    public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
    private Boolean fundsProcessed;
    public static final String JSON_PROPERTY_REFUNDS = "refunds";
    private List<Refund> refunds = new ArrayList<Refund>();
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private String sourceCurrency;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    private String internalCurrency;
    public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
    private String captureCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private Double sourceAmount;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
    private Double displayAmount;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    private Double supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    private Double internalAmount;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
    private Double captureAmount;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
    private Double sourceAmountRefundModifier;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
    private Double displayAmountRefundModifier;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
    private Double supplierAmountRefundModifier;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
    private Double internalAmountRefundModifier;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
    private Double captureAmountRefundModifier;
    public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
    private Double netCaptureAmount;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
    private Double netSupplierAmount;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
    private Boolean cancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_LODGING = "lodging";
    private BookingContractItem lodging;
    public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
    private Long totalTokensEarned;
    public static final String JSON_PROPERTY_LODGING_ITINERARY = "lodgingItinerary";
    private Itinerary lodgingItinerary;
    public static final String JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY = "totalFundsGroupedByBeneficiary";
    private List<Beneficiary> totalFundsGroupedByBeneficiary = new ArrayList<Beneficiary>();
    public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
    private Double netSourceAmount;
    public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
    private Double netDisplayAmount;
    public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
    private Double netInternalAmount;
    public static final String JSON_PROPERTY_REFUNDABLE = "refundable";
    private Boolean refundable;
    public static final String JSON_PROPERTY_REFUNDED = "refunded";
    private Boolean refunded;

    public BookingContract id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BookingContract createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public BookingContract lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public BookingContract version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Long version) {
        this.version = version;
    }

    public BookingContract ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public BookingContract traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public BookingContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public BookingContract identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public BookingContract supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public BookingContract supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BookingContract displayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public BookingContract supplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public BookingContract internalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public BookingContract capturePriceQuote(Quote capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(Quote capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    public BookingContract itemList(List<BookingContractItem> itemList) {
        this.itemList = itemList;
        return this;
    }

    public BookingContract addItemListItem(BookingContractItem itemListItem) {
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BookingContractItem> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(List<BookingContractItem> itemList) {
        this.itemList = itemList;
    }

    public BookingContract externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public BookingContract externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public BookingContract payment(BookingContractPaymentDetails payment) {
        this.payment = payment;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingContractPaymentDetails getPayment() {
        return this.payment;
    }

    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayment(BookingContractPaymentDetails payment) {
        this.payment = payment;
    }

    public BookingContract cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContract cancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCancelledOn() {
        return this.cancelledOn;
    }

    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
    }

    public BookingContract canceller(CancellerEnum canceller) {
        this.canceller = canceller;
        return this;
    }

    @Nullable
    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellerEnum getCanceller() {
        return this.canceller;
    }

    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanceller(CancellerEnum canceller) {
        this.canceller = canceller;
    }

    public BookingContract cancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationTypeEnum getCancellationType() {
        return this.cancellationType;
    }

    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
    }

    public BookingContract cancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancellerUserIdentifier() {
        return this.cancellerUserIdentifier;
    }

    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
    }

    public BookingContract cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public BookingContract fundsAddedToLedger(Boolean fundsAddedToLedger) {
        this.fundsAddedToLedger = fundsAddedToLedger;
        return this;
    }

    @Nullable
    @JsonProperty(value="fundsAddedToLedger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsAddedToLedger() {
        return this.fundsAddedToLedger;
    }

    @JsonProperty(value="fundsAddedToLedger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsAddedToLedger(Boolean fundsAddedToLedger) {
        this.fundsAddedToLedger = fundsAddedToLedger;
    }

    public BookingContract fundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
        return this;
    }

    @Nullable
    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsProcessed() {
        return this.fundsProcessed;
    }

    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
    }

    public BookingContract refunds(List<Refund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public BookingContract addRefundsItem(Refund refundsItem) {
        if (this.refunds == null) {
            this.refunds = new ArrayList<Refund>();
        }
        this.refunds.add(refundsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public BookingContract sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public BookingContract displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public BookingContract supplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public BookingContract internalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public BookingContract captureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCaptureCurrency() {
        return this.captureCurrency;
    }

    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
    }

    public BookingContract sourceAmount(Double sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getSourceAmount() {
        return this.sourceAmount;
    }

    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmount(Double sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public BookingContract displayAmount(Double displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getDisplayAmount() {
        return this.displayAmount;
    }

    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmount(Double displayAmount) {
        this.displayAmount = displayAmount;
    }

    public BookingContract supplierAmount(Double supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(Double supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public BookingContract internalAmount(Double internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalAmount(Double internalAmount) {
        this.internalAmount = internalAmount;
    }

    public BookingContract captureAmount(Double captureAmount) {
        this.captureAmount = captureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getCaptureAmount() {
        return this.captureAmount;
    }

    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmount(Double captureAmount) {
        this.captureAmount = captureAmount;
    }

    public BookingContract sourceAmountRefundModifier(Double sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getSourceAmountRefundModifier() {
        return this.sourceAmountRefundModifier;
    }

    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAmountRefundModifier(Double sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    }

    public BookingContract displayAmountRefundModifier(Double displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getDisplayAmountRefundModifier() {
        return this.displayAmountRefundModifier;
    }

    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayAmountRefundModifier(Double displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
    }

    public BookingContract supplierAmountRefundModifier(Double supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getSupplierAmountRefundModifier() {
        return this.supplierAmountRefundModifier;
    }

    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierAmountRefundModifier(Double supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    }

    public BookingContract internalAmountRefundModifier(Double internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getInternalAmountRefundModifier() {
        return this.internalAmountRefundModifier;
    }

    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmountRefundModifier(Double internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
    }

    public BookingContract captureAmountRefundModifier(Double captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getCaptureAmountRefundModifier() {
        return this.captureAmountRefundModifier;
    }

    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureAmountRefundModifier(Double captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
    }

    public BookingContract netCaptureAmount(Double netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNetCaptureAmount() {
        return this.netCaptureAmount;
    }

    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCaptureAmount(Double netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
    }

    public BookingContract cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContract cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContract netSupplierAmount(Double netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNetSupplierAmount() {
        return this.netSupplierAmount;
    }

    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetSupplierAmount(Double netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
    }

    public BookingContract cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContract cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharges() {
        return this.cancellableWithPotentialCharges;
    }

    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    }

    public BookingContract lodging(BookingContractItem lodging) {
        this.lodging = lodging;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractItem getLodging() {
        return this.lodging;
    }

    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLodging(BookingContractItem lodging) {
        this.lodging = lodging;
    }

    public BookingContract totalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalTokensEarned() {
        return this.totalTokensEarned;
    }

    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
    }

    public BookingContract lodgingItinerary(Itinerary lodgingItinerary) {
        this.lodgingItinerary = lodgingItinerary;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lodgingItinerary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Itinerary getLodgingItinerary() {
        return this.lodgingItinerary;
    }

    @JsonProperty(value="lodgingItinerary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLodgingItinerary(Itinerary lodgingItinerary) {
        this.lodgingItinerary = lodgingItinerary;
    }

    public BookingContract totalFundsGroupedByBeneficiary(List<Beneficiary> totalFundsGroupedByBeneficiary) {
        this.totalFundsGroupedByBeneficiary = totalFundsGroupedByBeneficiary;
        return this;
    }

    public BookingContract addTotalFundsGroupedByBeneficiaryItem(Beneficiary totalFundsGroupedByBeneficiaryItem) {
        if (this.totalFundsGroupedByBeneficiary == null) {
            this.totalFundsGroupedByBeneficiary = new ArrayList<Beneficiary>();
        }
        this.totalFundsGroupedByBeneficiary.add(totalFundsGroupedByBeneficiaryItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFundsGroupedByBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Beneficiary> getTotalFundsGroupedByBeneficiary() {
        return this.totalFundsGroupedByBeneficiary;
    }

    @JsonProperty(value="totalFundsGroupedByBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFundsGroupedByBeneficiary(List<Beneficiary> totalFundsGroupedByBeneficiary) {
        this.totalFundsGroupedByBeneficiary = totalFundsGroupedByBeneficiary;
    }

    public BookingContract netSourceAmount(Double netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNetSourceAmount() {
        return this.netSourceAmount;
    }

    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetSourceAmount(Double netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
    }

    public BookingContract netDisplayAmount(Double netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNetDisplayAmount() {
        return this.netDisplayAmount;
    }

    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetDisplayAmount(Double netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
    }

    public BookingContract netInternalAmount(Double netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNetInternalAmount() {
        return this.netInternalAmount;
    }

    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetInternalAmount(Double netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
    }

    public BookingContract refundable(Boolean refundable) {
        this.refundable = refundable;
        return this;
    }

    @Nullable
    @JsonProperty(value="refundable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefundable() {
        return this.refundable;
    }

    @JsonProperty(value="refundable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundable(Boolean refundable) {
        this.refundable = refundable;
    }

    public BookingContract refunded(Boolean refunded) {
        this.refunded = refunded;
        return this;
    }

    @Nullable
    @JsonProperty(value="refunded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRefunded() {
        return this.refunded;
    }

    @JsonProperty(value="refunded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContract bookingContract = (BookingContract)o;
        return Objects.equals(this.id, bookingContract.id) && Objects.equals(this.createdDate, bookingContract.createdDate) && Objects.equals(this.lastUpdate, bookingContract.lastUpdate) && Objects.equals(this.version, bookingContract.version) && Objects.equals(this.ipAddress, bookingContract.ipAddress) && Objects.equals(this.traceId, bookingContract.traceId) && Objects.equals(this.sourceUrl, bookingContract.sourceUrl) && Objects.equals(this.identifier, bookingContract.identifier) && Objects.equals(this.supplierIdentifier, bookingContract.supplierIdentifier) && Objects.equals(this.supplierName, bookingContract.supplierName) && Objects.equals(this.displayPriceQuote, bookingContract.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, bookingContract.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, bookingContract.internalPriceQuote) && Objects.equals(this.capturePriceQuote, bookingContract.capturePriceQuote) && Objects.equals(this.itemList, bookingContract.itemList) && Objects.equals(this.externalSupplierIdentifier, bookingContract.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, bookingContract.externalSupplierBookingCode) && Objects.equals(this.payment, bookingContract.payment) && Objects.equals(this.cancelled, bookingContract.cancelled) && Objects.equals(this.cancelledOn, bookingContract.cancelledOn) && Objects.equals((Object)this.canceller, (Object)bookingContract.canceller) && Objects.equals((Object)this.cancellationType, (Object)bookingContract.cancellationType) && Objects.equals(this.cancellerUserIdentifier, bookingContract.cancellerUserIdentifier) && Objects.equals(this.cancelReason, bookingContract.cancelReason) && Objects.equals(this.fundsAddedToLedger, bookingContract.fundsAddedToLedger) && Objects.equals(this.fundsProcessed, bookingContract.fundsProcessed) && Objects.equals(this.refunds, bookingContract.refunds) && Objects.equals(this.sourceCurrency, bookingContract.sourceCurrency) && Objects.equals(this.displayCurrency, bookingContract.displayCurrency) && Objects.equals(this.supplierCurrency, bookingContract.supplierCurrency) && Objects.equals(this.internalCurrency, bookingContract.internalCurrency) && Objects.equals(this.captureCurrency, bookingContract.captureCurrency) && Objects.equals(this.sourceAmount, bookingContract.sourceAmount) && Objects.equals(this.displayAmount, bookingContract.displayAmount) && Objects.equals(this.supplierAmount, bookingContract.supplierAmount) && Objects.equals(this.internalAmount, bookingContract.internalAmount) && Objects.equals(this.captureAmount, bookingContract.captureAmount) && Objects.equals(this.sourceAmountRefundModifier, bookingContract.sourceAmountRefundModifier) && Objects.equals(this.displayAmountRefundModifier, bookingContract.displayAmountRefundModifier) && Objects.equals(this.supplierAmountRefundModifier, bookingContract.supplierAmountRefundModifier) && Objects.equals(this.internalAmountRefundModifier, bookingContract.internalAmountRefundModifier) && Objects.equals(this.captureAmountRefundModifier, bookingContract.captureAmountRefundModifier) && Objects.equals(this.netCaptureAmount, bookingContract.netCaptureAmount) && Objects.equals(this.cancellableByTraveler, bookingContract.cancellableByTraveler) && Objects.equals(this.cancellableBySupplier, bookingContract.cancellableBySupplier) && Objects.equals(this.netSupplierAmount, bookingContract.netSupplierAmount) && Objects.equals(this.cancellableWithNoCharges, bookingContract.cancellableWithNoCharges) && Objects.equals(this.cancellableWithPotentialCharges, bookingContract.cancellableWithPotentialCharges) && Objects.equals(this.lodging, bookingContract.lodging) && Objects.equals(this.totalTokensEarned, bookingContract.totalTokensEarned) && Objects.equals(this.lodgingItinerary, bookingContract.lodgingItinerary) && Objects.equals(this.totalFundsGroupedByBeneficiary, bookingContract.totalFundsGroupedByBeneficiary) && Objects.equals(this.netSourceAmount, bookingContract.netSourceAmount) && Objects.equals(this.netDisplayAmount, bookingContract.netDisplayAmount) && Objects.equals(this.netInternalAmount, bookingContract.netInternalAmount) && Objects.equals(this.refundable, bookingContract.refundable) && Objects.equals(this.refunded, bookingContract.refunded);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.payment, this.cancelled, this.cancelledOn, this.canceller, this.cancellationType, this.cancellerUserIdentifier, this.cancelReason, this.fundsAddedToLedger, this.fundsProcessed, this.refunds, this.sourceCurrency, this.displayCurrency, this.supplierCurrency, this.internalCurrency, this.captureCurrency, this.sourceAmount, this.displayAmount, this.supplierAmount, this.internalAmount, this.captureAmount, this.sourceAmountRefundModifier, this.displayAmountRefundModifier, this.supplierAmountRefundModifier, this.internalAmountRefundModifier, this.captureAmountRefundModifier, this.netCaptureAmount, this.cancellableByTraveler, this.cancellableBySupplier, this.netSupplierAmount, this.cancellableWithNoCharges, this.cancellableWithPotentialCharges, this.lodging, this.totalTokensEarned, this.lodgingItinerary, this.totalFundsGroupedByBeneficiary, this.netSourceAmount, this.netDisplayAmount, this.netInternalAmount, this.refundable, this.refunded});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContract {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    cancelledOn: ").append(this.toIndentedString(this.cancelledOn)).append("\n");
        sb.append("    canceller: ").append(this.toIndentedString((Object)this.canceller)).append("\n");
        sb.append("    cancellationType: ").append(this.toIndentedString((Object)this.cancellationType)).append("\n");
        sb.append("    cancellerUserIdentifier: ").append(this.toIndentedString(this.cancellerUserIdentifier)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    fundsAddedToLedger: ").append(this.toIndentedString(this.fundsAddedToLedger)).append("\n");
        sb.append("    fundsProcessed: ").append(this.toIndentedString(this.fundsProcessed)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    captureCurrency: ").append(this.toIndentedString(this.captureCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    displayAmount: ").append(this.toIndentedString(this.displayAmount)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("    captureAmount: ").append(this.toIndentedString(this.captureAmount)).append("\n");
        sb.append("    sourceAmountRefundModifier: ").append(this.toIndentedString(this.sourceAmountRefundModifier)).append("\n");
        sb.append("    displayAmountRefundModifier: ").append(this.toIndentedString(this.displayAmountRefundModifier)).append("\n");
        sb.append("    supplierAmountRefundModifier: ").append(this.toIndentedString(this.supplierAmountRefundModifier)).append("\n");
        sb.append("    internalAmountRefundModifier: ").append(this.toIndentedString(this.internalAmountRefundModifier)).append("\n");
        sb.append("    captureAmountRefundModifier: ").append(this.toIndentedString(this.captureAmountRefundModifier)).append("\n");
        sb.append("    netCaptureAmount: ").append(this.toIndentedString(this.netCaptureAmount)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    netSupplierAmount: ").append(this.toIndentedString(this.netSupplierAmount)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    cancellableWithPotentialCharges: ").append(this.toIndentedString(this.cancellableWithPotentialCharges)).append("\n");
        sb.append("    lodging: ").append(this.toIndentedString(this.lodging)).append("\n");
        sb.append("    totalTokensEarned: ").append(this.toIndentedString(this.totalTokensEarned)).append("\n");
        sb.append("    lodgingItinerary: ").append(this.toIndentedString(this.lodgingItinerary)).append("\n");
        sb.append("    totalFundsGroupedByBeneficiary: ").append(this.toIndentedString(this.totalFundsGroupedByBeneficiary)).append("\n");
        sb.append("    netSourceAmount: ").append(this.toIndentedString(this.netSourceAmount)).append("\n");
        sb.append("    netDisplayAmount: ").append(this.toIndentedString(this.netDisplayAmount)).append("\n");
        sb.append("    netInternalAmount: ").append(this.toIndentedString(this.netInternalAmount)).append("\n");
        sb.append("    refundable: ").append(this.toIndentedString(this.refundable)).append("\n");
        sb.append("    refunded: ").append(this.toIndentedString(this.refunded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER"),
        ACQUIRER("ACQUIRER"),
        ADMINISTRATOR("ADMINISTRATOR");

        private String value;

        private CancellerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerEnum fromValue(String value) {
            for (CancellerEnum b : CancellerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationTypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private CancellationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationTypeEnum fromValue(String value) {
            for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

