/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.acquiring.model.VariableCharge;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonPropertyOrder(value={"identifier", "identifierType", "amountDue", "type"})
public class RawBeneficiary {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_IDENTIFIER_TYPE = "identifierType";
    private IdentifierTypeEnum identifierType;
    public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
    private VariableCharge amountDue;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public RawBeneficiary identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public RawBeneficiary identifierType(IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentifierTypeEnum getIdentifierType() {
        return this.identifierType;
    }

    @JsonProperty(value="identifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifierType(IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
    }

    public RawBeneficiary amountDue(VariableCharge amountDue) {
        this.amountDue = amountDue;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="amountDue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VariableCharge getAmountDue() {
        return this.amountDue;
    }

    @JsonProperty(value="amountDue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDue(VariableCharge amountDue) {
        this.amountDue = amountDue;
    }

    public RawBeneficiary type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawBeneficiary rawBeneficiary = (RawBeneficiary)o;
        return Objects.equals(this.identifier, rawBeneficiary.identifier) && Objects.equals((Object)this.identifierType, (Object)rawBeneficiary.identifierType) && Objects.equals(this.amountDue, rawBeneficiary.amountDue) && Objects.equals((Object)this.type, (Object)rawBeneficiary.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.identifierType, this.amountDue, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawBeneficiary {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    identifierType: ").append(this.toIndentedString((Object)this.identifierType)).append("\n");
        sb.append("    amountDue: ").append(this.toIndentedString(this.amountDue)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private IdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IdentifierTypeEnum fromValue(String value) {
            for (IdentifierTypeEnum b : IdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        TRIP_PAY("TRIP_PAY"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

