/*
 * TripPay
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release  # Intended Audience This document is for developers and travel space enthusiasts who wish to simplify the payment of travel inventory.  ## Examples: - Get set up as a travel agent with us. We either invoice you or you have a topped up account we can use to disburse funds to customers. - Use our payment widget and let us do the hard work of processing the payment. You get paid once the traveler checks out.
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@trippay.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateMappingRequest
 */
@JsonPropertyOrder({
  CreateMappingRequest.JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER,
  CreateMappingRequest.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  CreateMappingRequest.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  CreateMappingRequest.JSON_PROPERTY_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:59:53.026693+07:00[Asia/Bangkok]")
public class CreateMappingRequest {
  public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
  private String localAccountIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private String accountIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public CreateMappingRequest() { 
  }

  @JsonCreator
  public CreateMappingRequest(
    @JsonProperty(JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER) String localAccountIdentifier, 
    @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER) String externalIdentifier, 
    @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER) String accountIdentifier, 
    @JsonProperty(JSON_PROPERTY_NAME) String name
  ) {
    this();
    this.localAccountIdentifier = localAccountIdentifier;
    this.externalIdentifier = externalIdentifier;
    this.accountIdentifier = accountIdentifier;
    this.name = name;
  }

   /**
   * Local account identifier is the platform identifier
   * @return localAccountIdentifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "hotel-1", required = true, value = "Local account identifier is the platform identifier")
  @JsonProperty(JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocalAccountIdentifier() {
    return localAccountIdentifier;
  }




   /**
   * External identifier is the identifier of this entity in a remote system
   * @return externalIdentifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "hotel-a", required = true, value = "External identifier is the identifier of this entity in a remote system")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }




   /**
   * Account identifier is the account doing the mapping
   * @return accountIdentifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "account-1", required = true, value = "Account identifier is the account doing the mapping")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountIdentifier() {
    return accountIdentifier;
  }




   /**
   * Name of the entity being mapped
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Sheraton Hua Hin", required = true, value = "Name of the entity being mapped")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateMappingRequest createMappingRequest = (CreateMappingRequest) o;
    return Objects.equals(this.localAccountIdentifier, createMappingRequest.localAccountIdentifier) &&
        Objects.equals(this.externalIdentifier, createMappingRequest.externalIdentifier) &&
        Objects.equals(this.accountIdentifier, createMappingRequest.accountIdentifier) &&
        Objects.equals(this.name, createMappingRequest.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(localAccountIdentifier, externalIdentifier, accountIdentifier, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateMappingRequest {\n");
    sb.append("    localAccountIdentifier: ").append(toIndentedString(localAccountIdentifier)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

