/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="Person doing the booking.")
@JsonPropertyOrder(value={"externalIdentifier", "firstName", "lastName", "email", "telephone"})
public class BookingUser {
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_TELEPHONE = "telephone";
    private String telephone;

    public BookingUser externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user-1", value="External user externalIdentifier")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public BookingUser firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="John", required=true, value="First name")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public BookingUser lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Smith", required=true, value="Last name")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public BookingUser email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="john.smith@email.com", required=true, value="Email")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public BookingUser telephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0123456789", value="Telephone")
    @JsonProperty(value="telephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephone() {
        return this.telephone;
    }

    @JsonProperty(value="telephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingUser bookingUser = (BookingUser)o;
        return Objects.equals(this.externalIdentifier, bookingUser.externalIdentifier) && Objects.equals(this.firstName, bookingUser.firstName) && Objects.equals(this.lastName, bookingUser.lastName) && Objects.equals(this.email, bookingUser.email) && Objects.equals(this.telephone, bookingUser.telephone);
    }

    public int hashCode() {
        return Objects.hash(this.externalIdentifier, this.firstName, this.lastName, this.email, this.telephone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingUser {\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    telephone: ").append(this.toIndentedString(this.telephone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

