/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.payment.model.Moneys;

@ApiModel(description="In case of LODGING, include daily rates")
@JsonPropertyOrder(value={"date", "price", "displayPrice", "supplierPrice", "internalPrice", "capturePrice"})
public class DailyRate {
    public static final String JSON_PROPERTY_DATE = "date";
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_PRICE = "price";
    private Moneys price;
    public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
    private Moneys displayPrice;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
    private Moneys supplierPrice;
    public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
    private Moneys internalPrice;
    public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
    private Moneys capturePrice;

    public DailyRate date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The date this rate is applicable for.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public DailyRate price(Moneys price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(Moneys price) {
        this.price = price;
    }

    public DailyRate displayPrice(Moneys displayPrice) {
        this.displayPrice = displayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getDisplayPrice() {
        return this.displayPrice;
    }

    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPrice(Moneys displayPrice) {
        this.displayPrice = displayPrice;
    }

    public DailyRate supplierPrice(Moneys supplierPrice) {
        this.supplierPrice = supplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getSupplierPrice() {
        return this.supplierPrice;
    }

    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPrice(Moneys supplierPrice) {
        this.supplierPrice = supplierPrice;
    }

    public DailyRate internalPrice(Moneys internalPrice) {
        this.internalPrice = internalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getInternalPrice() {
        return this.internalPrice;
    }

    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPrice(Moneys internalPrice) {
        this.internalPrice = internalPrice;
    }

    public DailyRate capturePrice(Moneys capturePrice) {
        this.capturePrice = capturePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getCapturePrice() {
        return this.capturePrice;
    }

    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePrice(Moneys capturePrice) {
        this.capturePrice = capturePrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyRate dailyRate = (DailyRate)o;
        return Objects.equals(this.date, dailyRate.date) && Objects.equals(this.price, dailyRate.price) && Objects.equals(this.displayPrice, dailyRate.displayPrice) && Objects.equals(this.supplierPrice, dailyRate.supplierPrice) && Objects.equals(this.internalPrice, dailyRate.internalPrice) && Objects.equals(this.capturePrice, dailyRate.capturePrice);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.price, this.displayPrice, this.supplierPrice, this.internalPrice, this.capturePrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyRate {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    displayPrice: ").append(this.toIndentedString(this.displayPrice)).append("\n");
        sb.append("    supplierPrice: ").append(this.toIndentedString(this.supplierPrice)).append("\n");
        sb.append("    internalPrice: ").append(this.toIndentedString(this.internalPrice)).append("\n");
        sb.append("    capturePrice: ").append(this.toIndentedString(this.capturePrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

