/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.payment.model.RawSupplierContract;

@ApiModel(description="contract that started it all")
@JsonPropertyOrder(value={"apiKey", "displayCurrency", "sourceUrl", "contractList", "traceId"})
public class RawBookingContract {
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_CONTRACT_LIST = "contractList";
    private List<RawSupplierContract> contractList = new ArrayList<RawSupplierContract>();
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;

    public RawBookingContract apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="API key for the integrating account making the call")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public RawBookingContract displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired quote")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public RawBookingContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public RawBookingContract contractList(List<RawSupplierContract> contractList) {
        this.contractList = contractList;
        return this;
    }

    public RawBookingContract addContractListItem(RawSupplierContract contractListItem) {
        this.contractList.add(contractListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawSupplierContract> getContractList() {
        return this.contractList;
    }

    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractList(List<RawSupplierContract> contractList) {
        this.contractList = contractList;
    }

    public RawBookingContract traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="integrator-booking-code-1", value="Integrator can choose to include a unique identifier to help identify the collection of bookings")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawBookingContract rawBookingContract = (RawBookingContract)o;
        return Objects.equals(this.apiKey, rawBookingContract.apiKey) && Objects.equals(this.displayCurrency, rawBookingContract.displayCurrency) && Objects.equals(this.sourceUrl, rawBookingContract.sourceUrl) && Objects.equals(this.contractList, rawBookingContract.contractList) && Objects.equals(this.traceId, rawBookingContract.traceId);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.displayCurrency, this.sourceUrl, this.contractList, this.traceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawBookingContract {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    contractList: ").append(this.toIndentedString(this.contractList)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

