/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"apiKey", "type", "domains"})
public class UpdateIntegrationRequest {
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    private List<String> domains = new ArrayList<String>();

    public UpdateIntegrationRequest apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="api-key-123", required=true, value="apiKey is sent along with the booking contract.")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public UpdateIntegrationRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MERCHANT", required=true, value="Type determines whether the booking will be paid by the agent or by the traveler.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpdateIntegrationRequest domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public UpdateIntegrationRequest addDomainsItem(String domainsItem) {
        this.domains.add(domainsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=0, max=0x7FFFFFFF)
    @ApiModelProperty(example="https://book.trippay.io", required=true, value="Integration needs to know where it will be integrated.")
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=0, max=0x7FFFFFFF) List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateIntegrationRequest updateIntegrationRequest = (UpdateIntegrationRequest)o;
        return Objects.equals(this.apiKey, updateIntegrationRequest.apiKey) && Objects.equals((Object)this.type, (Object)updateIntegrationRequest.type) && Objects.equals(this.domains, updateIntegrationRequest.domains);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiKey, this.type, this.domains});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateIntegrationRequest {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        AGENT("AGENT"),
        MERCHANT("MERCHANT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

