package travel.wink.sdk.payment.api;

import travel.wink.sdk.payment.invoker.ApiClient;

import travel.wink.sdk.payment.model.CreateMappingRequest;
import travel.wink.sdk.payment.model.Mapping;
import travel.wink.sdk.payment.model.UpdateMappingRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:24.301796+07:00[Asia/Bangkok]")
public class MappingApi {
    private ApiClient apiClient;

    public MappingApi() {
        this(new ApiClient());
    }

    @Autowired
    public MappingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Mapping
     * Create a mapping between two accounts
     * <p><b>200</b> - OK
     * @param createMappingRequest The createMappingRequest parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMappingRequestCreation(CreateMappingRequest createMappingRequest) throws WebClientResponseException {
        Object postBody = createMappingRequest;
        // verify the required parameter 'createMappingRequest' is set
        if (createMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMappingRequest' when calling createMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Mapping
     * Create a mapping between two accounts
     * <p><b>200</b> - OK
     * @param createMappingRequest The createMappingRequest parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> createMapping(CreateMappingRequest createMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createMappingRequestCreation(createMappingRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> createMappingWithHttpInfo(CreateMappingRequest createMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createMappingRequestCreation(createMappingRequest).toEntity(localVarReturnType);
    }
    /**
     * Show Mapping
     * Show a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadMappingRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Mapping
     * Show a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> loadMapping(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingRequestCreation(id, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadMappingWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingRequestCreation(id, accept).toEntity(localVarReturnType);
    }
    /**
     * Show External Mapping
     * Show a specific mapping contract by external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadMappingByExternalIdentifierRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show External Mapping
     * Show a specific mapping contract by external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> loadMappingByExternalIdentifier(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingByExternalIdentifierRequestCreation(id, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadMappingByExternalIdentifierWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingByExternalIdentifierRequestCreation(id, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Mappings
     * List all mappings
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadMappingsRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Mappings
     * List all mappings
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Mapping> loadMappings(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingsRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Mapping>>> loadMappingsWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingsRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Delete Mapping
     * Delete a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMappingRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Mapping
     * Delete a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> removeMapping(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingRequestCreation(id, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> removeMappingWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingRequestCreation(id, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete External Mapping
     * Delete a specific mapping contract based on its external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMappingByExternalIdentifierRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete External Mapping
     * Delete a specific mapping contract based on its external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> removeMappingByExternalIdentifier(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingByExternalIdentifierRequestCreation(id, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> removeMappingByExternalIdentifierWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingByExternalIdentifierRequestCreation(id, accept).toEntity(localVarReturnType);
    }
    /**
     * Update Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMappingRequestCreation(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        Object postBody = updateMappingRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateMappingRequest' is set
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> updateMapping(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingRequestCreation(id, updateMappingRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateMappingWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingRequestCreation(id, updateMappingRequest).toEntity(localVarReturnType);
    }
    /**
     * Update External Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMappingByExternalIdentifierRequestCreation(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        Object postBody = updateMappingRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateMappingRequest' is set
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update External Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> updateMappingByExternalIdentifier(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateMappingByExternalIdentifierWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest).toEntity(localVarReturnType);
    }
}
