/*
 * TripPay
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release  # Intended Audience This document is for developers and travel space enthusiasts who wish to simplify the payment of travel inventory.  ## Examples: - Get set up as a travel agent with us. We either invoice you or you have a topped up account we can use to disburse funds to customers. - Use our payment widget and let us do the hard work of processing the payment. You get paid once the traveler checks out.
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@trippay.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * How we interact with the acquirer
 */
@ApiModel(description = "How we interact with the acquirer")
@JsonPropertyOrder({
  AcquirerCredentials.JSON_PROPERTY_TYPE,
  AcquirerCredentials.JSON_PROPERTY_KEY1,
  AcquirerCredentials.JSON_PROPERTY_KEY2
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:24.301796+07:00[Asia/Bangkok]")
public class AcquirerCredentials {
  /**
   * Type of credentials
   */
  public enum TypeEnum {
    TOKEN("TOKEN"),
    
    MERCHANT_IDENTIFIER("MERCHANT_IDENTIFIER"),
    
    WEBHOOK("WEBHOOK"),
    
    SECRET("SECRET");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_KEY1 = "key1";
  private String key1;

  public static final String JSON_PROPERTY_KEY2 = "key2";
  private String key2;

  public AcquirerCredentials() { 
  }

  public AcquirerCredentials type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of credentials
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Type of credentials")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public AcquirerCredentials key1(String key1) {
    
    this.key1 = key1;
    return this;
  }

   /**
   * A key that can be used as a token
   * @return key1
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "token-1", required = true, value = "A key that can be used as a token")
  @JsonProperty(JSON_PROPERTY_KEY1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getKey1() {
    return key1;
  }


  @JsonProperty(JSON_PROPERTY_KEY1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKey1(String key1) {
    this.key1 = key1;
  }


  public AcquirerCredentials key2(String key2) {
    
    this.key2 = key2;
    return this;
  }

   /**
   * Can be used alongside key1 as credentials
   * @return key2
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "token-2", required = true, value = "Can be used alongside key1 as credentials")
  @JsonProperty(JSON_PROPERTY_KEY2)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getKey2() {
    return key2;
  }


  @JsonProperty(JSON_PROPERTY_KEY2)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKey2(String key2) {
    this.key2 = key2;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquirerCredentials acquirerCredentials = (AcquirerCredentials) o;
    return Objects.equals(this.type, acquirerCredentials.type) &&
        Objects.equals(this.key1, acquirerCredentials.key1) &&
        Objects.equals(this.key2, acquirerCredentials.key2);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, key1, key2);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquirerCredentials {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    key1: ").append(toIndentedString(key1)).append("\n");
    sb.append("    key2: ").append(toIndentedString(key2)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

