/*
 * TripPay
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release  # Intended Audience This document is for developers and travel space enthusiasts who wish to simplify the payment of travel inventory.  ## Examples: - Get set up as a travel agent with us. We either invoice you or you have a topped up account we can use to disburse funds to customers. - Use our payment widget and let us do the hard work of processing the payment. You get paid once the traveler checks out.
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@trippay.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Descriptors used for filtering the result set
 */
@ApiModel(description = "Descriptors used for filtering the result set")
@JsonPropertyOrder({
  CompositeFilterDescriptor.JSON_PROPERTY_FIELD,
  CompositeFilterDescriptor.JSON_PROPERTY_OPERATOR,
  CompositeFilterDescriptor.JSON_PROPERTY_VALUE,
  CompositeFilterDescriptor.JSON_PROPERTY_IGNORE_CASE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:24.301796+07:00[Asia/Bangkok]")
public class CompositeFilterDescriptor {
  public static final String JSON_PROPERTY_FIELD = "field";
  private String field;

  /**
   * Filter operator to use on field
   */
  public enum OperatorEnum {
    NEQ("neq"),
    
    EQ("eq"),
    
    CONTAINS("contains"),
    
    DOESNOTCONTAIN("doesnotcontain"),
    
    ISNULL("isnull"),
    
    ISNOTNULL("isnotnull"),
    
    ISEMPTY("isempty"),
    
    ISNOTEMPTY("isnotempty"),
    
    STARTSWITH("startsWith"),
    
    ENDSWITH("endsWith"),
    
    GTE("gte"),
    
    LTE("lte"),
    
    GT("gt"),
    
    LT("lt");

    private String value;

    OperatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OperatorEnum fromValue(String value) {
      for (OperatorEnum b : OperatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OPERATOR = "operator";
  private OperatorEnum operator;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Object value;

  public static final String JSON_PROPERTY_IGNORE_CASE = "ignoreCase";
  private Boolean ignoreCase;

  public CompositeFilterDescriptor() { 
  }

  public CompositeFilterDescriptor field(String field) {
    
    this.field = field;
    return this;
  }

   /**
   * Field name to filter on
   * @return field
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel.name", value = "Field name to filter on")
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(String field) {
    this.field = field;
  }


  public CompositeFilterDescriptor operator(OperatorEnum operator) {
    
    this.operator = operator;
    return this;
  }

   /**
   * Filter operator to use on field
   * @return operator
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "startsWith", value = "Filter operator to use on field")
  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperatorEnum getOperator() {
    return operator;
  }


  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperator(OperatorEnum operator) {
    this.operator = operator;
  }


  public CompositeFilterDescriptor value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * Value to filter dataset against
   * @return value
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Happy Res", value = "Value to filter dataset against")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Object value) {
    this.value = value;
  }


  public CompositeFilterDescriptor ignoreCase(Boolean ignoreCase) {
    
    this.ignoreCase = ignoreCase;
    return this;
  }

   /**
   * Make filter comparison case insensitive. Default: Case sensitive 
   * @return ignoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Make filter comparison case insensitive. Default: Case sensitive ")
  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreCase() {
    return ignoreCase;
  }


  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoreCase(Boolean ignoreCase) {
    this.ignoreCase = ignoreCase;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompositeFilterDescriptor compositeFilterDescriptor = (CompositeFilterDescriptor) o;
    return Objects.equals(this.field, compositeFilterDescriptor.field) &&
        Objects.equals(this.operator, compositeFilterDescriptor.operator) &&
        Objects.equals(this.value, compositeFilterDescriptor.value) &&
        Objects.equals(this.ignoreCase, compositeFilterDescriptor.ignoreCase);
  }

  @Override
  public int hashCode() {
    return Objects.hash(field, operator, value, ignoreCase);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompositeFilterDescriptor {\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    ignoreCase: ").append(toIndentedString(ignoreCase)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

