package travel.wink.sdk.payment.api;

import travel.wink.sdk.payment.invoker.ApiClient;

import travel.wink.sdk.payment.model.BookingContract;
import travel.wink.sdk.payment.model.BookingContractCancellableResponse;
import travel.wink.sdk.payment.model.CancelBookingContractRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:45.582730+07:00[Asia/Bangkok]")
public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingContractRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> cancelBookingContract(String identifier, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> cancelBookingContractWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest).toEntity(localVarReturnType);
    }
    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelGroupBookingContractRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> cancelGroupBookingContract(String traceId, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> cancelGroupBookingContractWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest).toEntityList(localVarReturnType);
    }
    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param accept The accept parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isContractCancellableRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param accept The accept parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractCancellableResponse> isContractCancellable(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractCancellableResponse>> isContractCancellableWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, accept).toEntity(localVarReturnType);
    }
    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param accept The accept parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isGroupContractCancellableRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param accept The accept parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContractCancellableResponse> isGroupContractCancellable(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContractCancellableResponse>>> isGroupContractCancellableWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, accept).toEntityList(localVarReturnType);
    }
    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param accept The accept parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractRequestCreation(String identifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param accept The accept parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> showContract(String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> showContractWithHttpInfo(String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param accept The accept parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractsRequestCreation(String traceId, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling showContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param accept The accept parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> showContracts(String traceId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> showContractsWithHttpInfo(String traceId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, accept).toEntityList(localVarReturnType);
    }
}
