/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.payment.model.Acquirer;
import travel.wink.sdk.payment.model.Address;
import travel.wink.sdk.payment.model.BankAccount;
import travel.wink.sdk.payment.model.Integration;

@ApiModel(description="Account holds KYC, bank account and contact information of an affiliate, supplier, payment or any type of entity that is to be a beneficiary of funds through the payment.")
@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "type", "ownerType", "accountOwnerIdentifier", "name", "userIdentifier", "accountEmail", "description", "url", "status", "currencyCode", "address", "integrations", "acquirers", "bankAccounts"})
public class Account {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private OffsetDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private OffsetDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER = "accountOwnerIdentifier";
    private String accountOwnerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private String userIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
    private String accountEmail;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.REGISTERED;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_INTEGRATIONS = "integrations";
    private List<Integration> integrations = null;
    public static final String JSON_PROPERTY_ACQUIRERS = "acquirers";
    private List<Acquirer> acquirers = null;
    public static final String JSON_PROPERTY_BANK_ACCOUNTS = "bankAccounts";
    private List<BankAccount> bankAccounts = null;

    public Account() {
    }

    @JsonCreator
    public Account(@JsonProperty(value="id") String id, @JsonProperty(value="createdDate") OffsetDateTime createdDate, @JsonProperty(value="lastUpdate") OffsetDateTime lastUpdate, @JsonProperty(value="version") Long version, @JsonProperty(value="status") StatusEnum status) {
        this();
        this.id = id;
        this.createdDate = createdDate;
        this.lastUpdate = lastUpdate;
        this.version = version;
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(example="doc-1", value="Document UUID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public Account type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MERCHANT", required=true, value="Type of account tells us what the account is capable of.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Account ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="COMPANY", required=true, value="Type of account owner tells us whether ths account is managed by a company or an individual.")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public Account accountOwnerIdentifier(String accountOwnerIdentifier) {
        this.accountOwnerIdentifier = accountOwnerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="wink-client-1", required=true, value="The entity that created this account.")
    @JsonProperty(value="accountOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountOwnerIdentifier() {
        return this.accountOwnerIdentifier;
    }

    @JsonProperty(value="accountOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountOwnerIdentifier(String accountOwnerIdentifier) {
        this.accountOwnerIdentifier = accountOwnerIdentifier;
    }

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Company", required=true, value="Name of company / full name of person")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Account userIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="user-1", required=true, value="The authenticated user that owns this account.")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public Account accountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="company@acme.com", required=true, value="Account email is where we will send KYC documents and other account specific mailings")
    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountEmail() {
        return this.accountEmail;
    }

    @JsonProperty(value="accountEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    public Account description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My Company is the best company ever.", required=true, value="Short company / person description.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Account url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://trippay.io", required=true, value="Company website. If private person with no personal website, link to main social network account.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Nonnull
    @ApiModelProperty(example="APPROVED", required=true, value="Account status shows if it's approved")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public Account currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="GBP", required=true, value="Account's main currency.")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Account address(Address address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public Account integrations(List<Integration> integrations) {
        this.integrations = integrations;
        return this;
    }

    public Account addIntegrationsItem(Integration integrationsItem) {
        if (this.integrations == null) {
            this.integrations = new ArrayList<Integration>();
        }
        this.integrations.add(integrationsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    @JsonProperty(value="integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntegrations(List<Integration> integrations) {
        this.integrations = integrations;
    }

    public Account acquirers(List<Acquirer> acquirers) {
        this.acquirers = acquirers;
        return this;
    }

    public Account addAcquirersItem(Acquirer acquirersItem) {
        if (this.acquirers == null) {
            this.acquirers = new ArrayList<Acquirer>();
        }
        this.acquirers.add(acquirersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Acquirer> getAcquirers() {
        return this.acquirers;
    }

    @JsonProperty(value="acquirers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirers(List<Acquirer> acquirers) {
        this.acquirers = acquirers;
    }

    public Account bankAccounts(List<BankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
        return this;
    }

    public Account addBankAccountsItem(BankAccount bankAccountsItem) {
        if (this.bankAccounts == null) {
            this.bankAccounts = new ArrayList<BankAccount>();
        }
        this.bankAccounts.add(bankAccountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    @JsonProperty(value="bankAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccounts(List<BankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.id, account.id) && Objects.equals(this.createdDate, account.createdDate) && Objects.equals(this.lastUpdate, account.lastUpdate) && Objects.equals(this.version, account.version) && Objects.equals((Object)this.type, (Object)account.type) && Objects.equals((Object)this.ownerType, (Object)account.ownerType) && Objects.equals(this.accountOwnerIdentifier, account.accountOwnerIdentifier) && Objects.equals(this.name, account.name) && Objects.equals(this.userIdentifier, account.userIdentifier) && Objects.equals(this.accountEmail, account.accountEmail) && Objects.equals(this.description, account.description) && Objects.equals(this.url, account.url) && Objects.equals((Object)this.status, (Object)account.status) && Objects.equals(this.currencyCode, account.currencyCode) && Objects.equals(this.address, account.address) && Objects.equals(this.integrations, account.integrations) && Objects.equals(this.acquirers, account.acquirers) && Objects.equals(this.bankAccounts, account.bankAccounts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.type, this.ownerType, this.accountOwnerIdentifier, this.name, this.userIdentifier, this.accountEmail, this.description, this.url, this.status, this.currencyCode, this.address, this.integrations, this.acquirers, this.bankAccounts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    accountOwnerIdentifier: ").append(this.toIndentedString(this.accountOwnerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    accountEmail: ").append(this.toIndentedString(this.accountEmail)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    integrations: ").append(this.toIndentedString(this.integrations)).append("\n");
        sb.append("    acquirers: ").append(this.toIndentedString(this.acquirers)).append("\n");
        sb.append("    bankAccounts: ").append(this.toIndentedString(this.bankAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        REGISTERED("REGISTERED"),
        VERIFICATION_EMAIL_SENT("VERIFICATION_EMAIL_SENT"),
        APPROVED("APPROVED"),
        DEACTIVATED("DEACTIVATED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        MERCHANT("MERCHANT"),
        AFFILIATE("AFFILIATE"),
        AGENT("AGENT"),
        FACILITATOR("FACILITATOR");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OwnerTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

