package travel.wink.sdk.payment.api;

import travel.wink.sdk.payment.invoker.ApiClient;

import travel.wink.sdk.payment.model.CreateAgentSaleRequest;
import travel.wink.sdk.payment.model.MultiBookingContractResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T13:49:59.170059+07:00[Asia/Bangkok]")
public class AgentApi {
    private ApiClient apiClient;

    public AgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public AgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Agent Sale
     * Attempt an immediate sale with Agent as acquirer. Checks for valid funds in account before booking instruction.
     * <p><b>200</b> - OK
     * @param createAgentSaleRequest The createAgentSaleRequest parameter
     * @return MultiBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAgentSaleRequestCreation(CreateAgentSaleRequest createAgentSaleRequest) throws WebClientResponseException {
        Object postBody = createAgentSaleRequest;
        // verify the required parameter 'createAgentSaleRequest' is set
        if (createAgentSaleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentSaleRequest' when calling createAgentSale", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MultiBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<MultiBookingContractResponse>() {};
        return apiClient.invokeAPI("/api/contract/payment/agent/sale", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Agent Sale
     * Attempt an immediate sale with Agent as acquirer. Checks for valid funds in account before booking instruction.
     * <p><b>200</b> - OK
     * @param createAgentSaleRequest The createAgentSaleRequest parameter
     * @return MultiBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MultiBookingContractResponse> createAgentSale(CreateAgentSaleRequest createAgentSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MultiBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<MultiBookingContractResponse>() {};
        return createAgentSaleRequestCreation(createAgentSaleRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MultiBookingContractResponse>> createAgentSaleWithHttpInfo(CreateAgentSaleRequest createAgentSaleRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MultiBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<MultiBookingContractResponse>() {};
        return createAgentSaleRequestCreation(createAgentSaleRequest).toEntity(localVarReturnType);
    }
}
