/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"localAccountIdentifier", "externalIdentifier"})
public class UpdateAccountMappingRequest {
    public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
    private String localAccountIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;

    public UpdateAccountMappingRequest() {
    }

    @JsonCreator
    public UpdateAccountMappingRequest(@JsonProperty(value="localAccountIdentifier") String localAccountIdentifier, @JsonProperty(value="externalIdentifier") String externalIdentifier) {
        this();
        this.localAccountIdentifier = localAccountIdentifier;
        this.externalIdentifier = externalIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="hotel-1", required=true, value="Local account identifier is the payment identifier")
    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocalAccountIdentifier() {
        return this.localAccountIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="hotel-a", required=true, value="External identifier is the identifier of this entity in a remote system")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountMappingRequest updateAccountMappingRequest = (UpdateAccountMappingRequest)o;
        return Objects.equals(this.localAccountIdentifier, updateAccountMappingRequest.localAccountIdentifier) && Objects.equals(this.externalIdentifier, updateAccountMappingRequest.externalIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.localAccountIdentifier, this.externalIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAccountMappingRequest {\n");
        sb.append("    localAccountIdentifier: ").append(this.toIndentedString(this.localAccountIdentifier)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

