/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"countryCode", "currencyCode", "accountHolderName", "routingNumber", "accountNumber"})
public class UpdateBankAccountRequest {
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_NAME = "accountHolderName";
    private String accountHolderName;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;

    public UpdateBankAccountRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="US", required=true, value="Country of bank account")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public UpdateBankAccountRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="Currency of bank account")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public UpdateBankAccountRequest accountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="12345678", required=true, value="Bank account holder name")
    @JsonProperty(value="accountHolderName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    @JsonProperty(value="accountHolderName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public UpdateBankAccountRequest routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="12345678", required=true, value="Bank account routing number. This is sort code in HK and Zengin code in JP.")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public UpdateBankAccountRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="12345678", required=true, value="Bank account number. In all EU countries, this would be the IBAN. In other countries, the routing number will apply as well.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateBankAccountRequest updateBankAccountRequest = (UpdateBankAccountRequest)o;
        return Objects.equals(this.countryCode, updateBankAccountRequest.countryCode) && Objects.equals(this.currencyCode, updateBankAccountRequest.currencyCode) && Objects.equals(this.accountHolderName, updateBankAccountRequest.accountHolderName) && Objects.equals(this.routingNumber, updateBankAccountRequest.routingNumber) && Objects.equals(this.accountNumber, updateBankAccountRequest.accountNumber);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.currencyCode, this.accountHolderName, this.routingNumber, this.accountNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateBankAccountRequest {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    accountHolderName: ").append(this.toIndentedString(this.accountHolderName)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

