/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.0.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Address information
 */
@ApiModel(description = "Address information")
@JsonPropertyOrder({
  Address.JSON_PROPERTY_ADDRESS1,
  Address.JSON_PROPERTY_ADDRESS2,
  Address.JSON_PROPERTY_CITY_NAME,
  Address.JSON_PROPERTY_STATE,
  Address.JSON_PROPERTY_POSTAL_CODE,
  Address.JSON_PROPERTY_COUNTY,
  Address.JSON_PROPERTY_COUNTRY_CODE,
  Address.JSON_PROPERTY_COUNTRY_NAME,
  Address.JSON_PROPERTY_CONTINENT_CODE,
  Address.JSON_PROPERTY_CONTINENT_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:46:50.435199+07:00[Asia/Bangkok]")
public class Address {
  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_STATE = "state";
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTY = "county";
  private String county;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public Address() { 
  }

  public Address address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Address line 1
   * @return address1
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "234 Near da beach", required = true, value = "Address line 1")
  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public Address address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Address line 2
   * @return address2
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Pebble #5001", value = "Address line 2")
  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public Address cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * Geo names city identifier this account is located in.
   * @return cityName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "geo-name-1", required = true, value = "Geo names city identifier this account is located in.")
  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public Address state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * State
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "CA", value = "State")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(String state) {
    this.state = state;
  }


  public Address postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal / zip code
   * @return postalCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "90210", required = true, value = "Postal / zip code")
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public Address county(String county) {
    
    this.county = county;
    return this;
  }

   /**
   * County
   * @return county
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Alameda county", value = "County")
  @JsonProperty(JSON_PROPERTY_COUNTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCounty() {
    return county;
  }


  @JsonProperty(JSON_PROPERTY_COUNTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCounty(String county) {
    this.county = county;
  }


  public Address countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Country code
   * @return countryCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "US", required = true, value = "Country code")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public Address countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country name
   * @return countryName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "United States", required = true, value = "Country name")
  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public Address continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Continent code
   * @return continentCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "NA", required = true, value = "Continent code")
  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public Address continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Continent name
   * @return continentName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "North America", required = true, value = "Continent name")
  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Address address = (Address) o;
    return Objects.equals(this.address1, address.address1) &&
        Objects.equals(this.address2, address.address2) &&
        Objects.equals(this.cityName, address.cityName) &&
        Objects.equals(this.state, address.state) &&
        Objects.equals(this.postalCode, address.postalCode) &&
        Objects.equals(this.county, address.county) &&
        Objects.equals(this.countryCode, address.countryCode) &&
        Objects.equals(this.countryName, address.countryName) &&
        Objects.equals(this.continentCode, address.continentCode) &&
        Objects.equals(this.continentName, address.continentName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address1, address2, cityName, state, postalCode, county, countryCode, countryName, continentCode, continentName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Address {\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    county: ").append(toIndentedString(county)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

