/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.0.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.payment.model.BookingContractItem;
import travel.wink.sdk.payment.model.BookingContractPaymentDetails;
import travel.wink.sdk.payment.model.Itinerary;
import travel.wink.sdk.payment.model.Moneys;
import travel.wink.sdk.payment.model.QuoteData;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A booking record is the contract that got created after a successful payment was submitted.
 */
@ApiModel(description = "A booking record is the contract that got created after a successful payment was submitted.")
@JsonPropertyOrder({
  BookingContract.JSON_PROPERTY_ID,
  BookingContract.JSON_PROPERTY_CREATED_DATE,
  BookingContract.JSON_PROPERTY_LAST_UPDATE,
  BookingContract.JSON_PROPERTY_VERSION,
  BookingContract.JSON_PROPERTY_IP_ADDRESS,
  BookingContract.JSON_PROPERTY_TRACE_ID,
  BookingContract.JSON_PROPERTY_SOURCE_URL,
  BookingContract.JSON_PROPERTY_IDENTIFIER,
  BookingContract.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContract.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContract.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContract.JSON_PROPERTY_ITEM_LIST,
  BookingContract.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContract.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContract.JSON_PROPERTY_PAYMENT,
  BookingContract.JSON_PROPERTY_CANCELLED,
  BookingContract.JSON_PROPERTY_CANCELLED_ON,
  BookingContract.JSON_PROPERTY_CANCELLER,
  BookingContract.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContract.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContract.JSON_PROPERTY_CANCEL_REASON,
  BookingContract.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContract.JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION,
  BookingContract.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION,
  BookingContract.JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION,
  BookingContract.JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION,
  BookingContract.JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION,
  BookingContract.JSON_PROPERTY_REFUNDED_DISPLAY_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDED_INTERNAL_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE,
  BookingContract.JSON_PROPERTY_REFUNDED_SOURCE_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContract.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContract.JSON_PROPERTY_LODGING_ITINERARY,
  BookingContract.JSON_PROPERTY_REFUNDED_CAPTURE_PRICE,
  BookingContract.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContract.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContract.JSON_PROPERTY_TOTAL_SOURCE_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  BookingContract.JSON_PROPERTY_TOTAL_CAPTURE_PRICE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:46:50.435199+07:00[Asia/Bangkok]")
public class BookingContract {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private OffsetDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private OffsetDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private QuoteData displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private QuoteData supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private QuoteData internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private QuoteData capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<BookingContractItem> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  private BookingContractPaymentDetails payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  private OffsetDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER"),
    
    ADMINISTRATOR("ADMINISTRATOR");

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  private String cancelReason;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  private Boolean cancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION = "totalSourcePriceAfterCancellation";
  private Moneys totalSourcePriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION = "totalSupplierPriceAfterCancellation";
  private Moneys totalSupplierPriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION = "totalDisplayPriceAfterCancellation";
  private Moneys totalDisplayPriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION = "totalInternalPriceAfterCancellation";
  private Moneys totalInternalPriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION = "totalCapturePriceAfterCancellation";
  private Moneys totalCapturePriceAfterCancellation;

  public static final String JSON_PROPERTY_REFUNDED_DISPLAY_PRICE = "refundedDisplayPrice";
  private Moneys refundedDisplayPrice;

  public static final String JSON_PROPERTY_REFUNDED_INTERNAL_PRICE = "refundedInternalPrice";
  private Moneys refundedInternalPrice;

  public static final String JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE = "refundedSupplierPrice";
  private Moneys refundedSupplierPrice;

  public static final String JSON_PROPERTY_REFUNDED_SOURCE_PRICE = "refundedSourcePrice";
  private Moneys refundedSourcePrice;

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_LODGING_ITINERARY = "lodgingItinerary";
  private Itinerary lodgingItinerary;

  public static final String JSON_PROPERTY_REFUNDED_CAPTURE_PRICE = "refundedCapturePrice";
  private Moneys refundedCapturePrice;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
  private Moneys totalSourcePrice;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private Moneys totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private Moneys totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private Moneys totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private Moneys totalCapturePrice;

  public BookingContract() { 
  }

  @JsonCreator
  public BookingContract(
    @JsonProperty(JSON_PROPERTY_ID) String id, 
    @JsonProperty(JSON_PROPERTY_CREATED_DATE) OffsetDateTime createdDate, 
    @JsonProperty(JSON_PROPERTY_LAST_UPDATE) OffsetDateTime lastUpdate, 
    @JsonProperty(JSON_PROPERTY_VERSION) Long version, 
    @JsonProperty(JSON_PROPERTY_TRACE_ID) String traceId, 
    @JsonProperty(JSON_PROPERTY_SOURCE_URL) String sourceUrl, 
    @JsonProperty(JSON_PROPERTY_IDENTIFIER) String identifier, 
    @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER) String supplierIdentifier, 
    @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME) String supplierName, 
    @JsonProperty(JSON_PROPERTY_ITEM_LIST) List<BookingContractItem> itemList, 
    @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER) String externalSupplierIdentifier, 
    @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE) String externalSupplierBookingCode
  ) {
    this();
    this.id = id;
    this.createdDate = createdDate;
    this.lastUpdate = lastUpdate;
    this.version = version;
    this.traceId = traceId;
    this.sourceUrl = sourceUrl;
    this.identifier = identifier;
    this.supplierIdentifier = supplierIdentifier;
    this.supplierName = supplierName;
    this.itemList = itemList;
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }

   /**
   * Document UUID
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "doc-1", value = "Document UUID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }




   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was first created")
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedDate() {
    return createdDate;
  }




   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was last updated")
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastUpdate() {
    return lastUpdate;
  }




   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12", value = "Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }




  public BookingContract ipAddress(String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * Caller&#39;s IP address
   * @return ipAddress
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "111.222.333.444", required = true, value = "Caller's IP address")
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


   /**
   * Way to track which booking contracts were made together
   * @return traceId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "T-123456", required = true, value = "Way to track which booking contracts were made together")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }




   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }




   /**
   * Unique identifier used to track the contract.
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "unique-supplier-booking-contract-1", required = true, value = "Unique identifier used to track the contract.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }




   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "supplier-1", required = true, value = "Supplier identifier")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }




   /**
   * Supplier name
   * @return supplierName
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Supplier One", required = true, value = "Supplier name")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }




  public BookingContract displayPriceQuote(QuoteData displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(QuoteData displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public BookingContract supplierPriceQuote(QuoteData supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(QuoteData supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public BookingContract internalPriceQuote(QuoteData internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(QuoteData internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public BookingContract capturePriceQuote(QuoteData capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(QuoteData capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


   /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
  **/
  @javax.annotation.Nonnull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Holds one booking line item for a specific supplier.")
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BookingContractItem> getItemList() {
    return itemList;
  }




   /**
   * Contract creator can choose to reference this record with her own identifier
   * @return externalSupplierIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "supplier-a", value = "Contract creator can choose to reference this record with her own identifier")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }




   /**
   * External booking code generated by the caller
   * @return externalSupplierBookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-booking-code-1", value = "External booking code generated by the caller")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }




  public BookingContract payment(BookingContractPaymentDetails payment) {
    
    this.payment = payment;
    return this;
  }

   /**
   * Get payment
   * @return payment
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingContractPaymentDetails getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayment(BookingContractPaymentDetails payment) {
    this.payment = payment;
  }


  public BookingContract cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional reference externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Optional reference externalIdentifier to remote inventory.")
  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContract cancelledOn(OffsetDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

   /**
   * When the booking was cancelled.
   * @return cancelledOn
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "When the booking was cancelled.")
  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(OffsetDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }


  public BookingContract canceller(CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

   /**
   * Type of entity that cancelled the booking.
   * @return canceller
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type of entity that cancelled the booking.")
  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(CancellerEnum canceller) {
    this.canceller = canceller;
  }


  public BookingContract cancellationType(CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

   /**
   * Reason type.
   * @return cancellationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason type.")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }


  public BookingContract cancellerUserIdentifier(String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

   /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User identifier that cancelled the entity.")
  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }


  public BookingContract cancelReason(String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

   /**
   * Reason for cancellation.
   * @return cancelReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason for cancellation.")
  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(String cancelReason) {
    this.cancelReason = cancelReason;
  }


  public BookingContract cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return cancellableWithPotentialCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }


  public BookingContract totalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
    
    this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
    return this;
  }

   /**
   * Get totalSourcePriceAfterCancellation
   * @return totalSourcePriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSourcePriceAfterCancellation() {
    return totalSourcePriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
    this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
  }


  public BookingContract totalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
    
    this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
    return this;
  }

   /**
   * Get totalSupplierPriceAfterCancellation
   * @return totalSupplierPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSupplierPriceAfterCancellation() {
    return totalSupplierPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
    this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
  }


  public BookingContract totalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
    
    this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
    return this;
  }

   /**
   * Get totalDisplayPriceAfterCancellation
   * @return totalDisplayPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalDisplayPriceAfterCancellation() {
    return totalDisplayPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
    this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
  }


  public BookingContract totalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
    
    this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
    return this;
  }

   /**
   * Get totalInternalPriceAfterCancellation
   * @return totalInternalPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalInternalPriceAfterCancellation() {
    return totalInternalPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
    this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
  }


  public BookingContract totalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
    
    this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
    return this;
  }

   /**
   * Get totalCapturePriceAfterCancellation
   * @return totalCapturePriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalCapturePriceAfterCancellation() {
    return totalCapturePriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
    this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
  }


  public BookingContract refundedDisplayPrice(Moneys refundedDisplayPrice) {
    
    this.refundedDisplayPrice = refundedDisplayPrice;
    return this;
  }

   /**
   * Get refundedDisplayPrice
   * @return refundedDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedDisplayPrice() {
    return refundedDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedDisplayPrice(Moneys refundedDisplayPrice) {
    this.refundedDisplayPrice = refundedDisplayPrice;
  }


  public BookingContract refundedInternalPrice(Moneys refundedInternalPrice) {
    
    this.refundedInternalPrice = refundedInternalPrice;
    return this;
  }

   /**
   * Get refundedInternalPrice
   * @return refundedInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedInternalPrice() {
    return refundedInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedInternalPrice(Moneys refundedInternalPrice) {
    this.refundedInternalPrice = refundedInternalPrice;
  }


  public BookingContract refundedSupplierPrice(Moneys refundedSupplierPrice) {
    
    this.refundedSupplierPrice = refundedSupplierPrice;
    return this;
  }

   /**
   * Get refundedSupplierPrice
   * @return refundedSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedSupplierPrice() {
    return refundedSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedSupplierPrice(Moneys refundedSupplierPrice) {
    this.refundedSupplierPrice = refundedSupplierPrice;
  }


  public BookingContract refundedSourcePrice(Moneys refundedSourcePrice) {
    
    this.refundedSourcePrice = refundedSourcePrice;
    return this;
  }

   /**
   * Get refundedSourcePrice
   * @return refundedSourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedSourcePrice() {
    return refundedSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedSourcePrice(Moneys refundedSourcePrice) {
    this.refundedSourcePrice = refundedSourcePrice;
  }


  public BookingContract totalTokensEarned(Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

   /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Total amount of tokens minted on this contract.")
  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }


  public BookingContract cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the cancellation comes at no cost to the traveler.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContract lodgingItinerary(Itinerary lodgingItinerary) {
    
    this.lodgingItinerary = lodgingItinerary;
    return this;
  }

   /**
   * Get lodgingItinerary
   * @return lodgingItinerary
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LODGING_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Itinerary getLodgingItinerary() {
    return lodgingItinerary;
  }


  @JsonProperty(JSON_PROPERTY_LODGING_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodgingItinerary(Itinerary lodgingItinerary) {
    this.lodgingItinerary = lodgingItinerary;
  }


  public BookingContract refundedCapturePrice(Moneys refundedCapturePrice) {
    
    this.refundedCapturePrice = refundedCapturePrice;
    return this;
  }

   /**
   * Get refundedCapturePrice
   * @return refundedCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getRefundedCapturePrice() {
    return refundedCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedCapturePrice(Moneys refundedCapturePrice) {
    this.refundedCapturePrice = refundedCapturePrice;
  }


  public BookingContract cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled completely by the traveller.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContract cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled completely by the supplier.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContract totalSourcePrice(Moneys totalSourcePrice) {
    
    this.totalSourcePrice = totalSourcePrice;
    return this;
  }

   /**
   * Get totalSourcePrice
   * @return totalSourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSourcePrice() {
    return totalSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePrice(Moneys totalSourcePrice) {
    this.totalSourcePrice = totalSourcePrice;
  }


  public BookingContract totalSupplierPrice(Moneys totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public BookingContract totalDisplayPrice(Moneys totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public BookingContract totalInternalPrice(Moneys totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPrice(Moneys totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public BookingContract totalCapturePrice(Moneys totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePrice(Moneys totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContract bookingContract = (BookingContract) o;
    return Objects.equals(this.id, bookingContract.id) &&
        Objects.equals(this.createdDate, bookingContract.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContract.lastUpdate) &&
        Objects.equals(this.version, bookingContract.version) &&
        Objects.equals(this.ipAddress, bookingContract.ipAddress) &&
        Objects.equals(this.traceId, bookingContract.traceId) &&
        Objects.equals(this.sourceUrl, bookingContract.sourceUrl) &&
        Objects.equals(this.identifier, bookingContract.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContract.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContract.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContract.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContract.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContract.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContract.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContract.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContract.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContract.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContract.payment) &&
        Objects.equals(this.cancelled, bookingContract.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContract.cancelledOn) &&
        Objects.equals(this.canceller, bookingContract.canceller) &&
        Objects.equals(this.cancellationType, bookingContract.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContract.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContract.cancelReason) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContract.cancellableWithPotentialCharges) &&
        Objects.equals(this.totalSourcePriceAfterCancellation, bookingContract.totalSourcePriceAfterCancellation) &&
        Objects.equals(this.totalSupplierPriceAfterCancellation, bookingContract.totalSupplierPriceAfterCancellation) &&
        Objects.equals(this.totalDisplayPriceAfterCancellation, bookingContract.totalDisplayPriceAfterCancellation) &&
        Objects.equals(this.totalInternalPriceAfterCancellation, bookingContract.totalInternalPriceAfterCancellation) &&
        Objects.equals(this.totalCapturePriceAfterCancellation, bookingContract.totalCapturePriceAfterCancellation) &&
        Objects.equals(this.refundedDisplayPrice, bookingContract.refundedDisplayPrice) &&
        Objects.equals(this.refundedInternalPrice, bookingContract.refundedInternalPrice) &&
        Objects.equals(this.refundedSupplierPrice, bookingContract.refundedSupplierPrice) &&
        Objects.equals(this.refundedSourcePrice, bookingContract.refundedSourcePrice) &&
        Objects.equals(this.totalTokensEarned, bookingContract.totalTokensEarned) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContract.cancellableWithNoCharges) &&
        Objects.equals(this.lodgingItinerary, bookingContract.lodgingItinerary) &&
        Objects.equals(this.refundedCapturePrice, bookingContract.refundedCapturePrice) &&
        Objects.equals(this.cancellableByTraveler, bookingContract.cancellableByTraveler) &&
        Objects.equals(this.cancellableBySupplier, bookingContract.cancellableBySupplier) &&
        Objects.equals(this.totalSourcePrice, bookingContract.totalSourcePrice) &&
        Objects.equals(this.totalSupplierPrice, bookingContract.totalSupplierPrice) &&
        Objects.equals(this.totalDisplayPrice, bookingContract.totalDisplayPrice) &&
        Objects.equals(this.totalInternalPrice, bookingContract.totalInternalPrice) &&
        Objects.equals(this.totalCapturePrice, bookingContract.totalCapturePrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, cancellableWithPotentialCharges, totalSourcePriceAfterCancellation, totalSupplierPriceAfterCancellation, totalDisplayPriceAfterCancellation, totalInternalPriceAfterCancellation, totalCapturePriceAfterCancellation, refundedDisplayPrice, refundedInternalPrice, refundedSupplierPrice, refundedSourcePrice, totalTokensEarned, cancellableWithNoCharges, lodgingItinerary, refundedCapturePrice, cancellableByTraveler, cancellableBySupplier, totalSourcePrice, totalSupplierPrice, totalDisplayPrice, totalInternalPrice, totalCapturePrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContract {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("    totalSourcePriceAfterCancellation: ").append(toIndentedString(totalSourcePriceAfterCancellation)).append("\n");
    sb.append("    totalSupplierPriceAfterCancellation: ").append(toIndentedString(totalSupplierPriceAfterCancellation)).append("\n");
    sb.append("    totalDisplayPriceAfterCancellation: ").append(toIndentedString(totalDisplayPriceAfterCancellation)).append("\n");
    sb.append("    totalInternalPriceAfterCancellation: ").append(toIndentedString(totalInternalPriceAfterCancellation)).append("\n");
    sb.append("    totalCapturePriceAfterCancellation: ").append(toIndentedString(totalCapturePriceAfterCancellation)).append("\n");
    sb.append("    refundedDisplayPrice: ").append(toIndentedString(refundedDisplayPrice)).append("\n");
    sb.append("    refundedInternalPrice: ").append(toIndentedString(refundedInternalPrice)).append("\n");
    sb.append("    refundedSupplierPrice: ").append(toIndentedString(refundedSupplierPrice)).append("\n");
    sb.append("    refundedSourcePrice: ").append(toIndentedString(refundedSourcePrice)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    lodgingItinerary: ").append(toIndentedString(lodgingItinerary)).append("\n");
    sb.append("    refundedCapturePrice: ").append(toIndentedString(refundedCapturePrice)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    totalSourcePrice: ").append(toIndentedString(totalSourcePrice)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

