/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.payment.model.BookingUser;
import travel.wink.sdk.payment.model.Itinerary;
import travel.wink.sdk.payment.model.Moneys;
import travel.wink.sdk.payment.model.RawBeneficiary;
import travel.wink.sdk.payment.model.RawDailyRate;
import travel.wink.sdk.payment.model.SupplierContractItemPolicy;

@ApiModel(description="Holds one booking line item for a specific supplier.")
@JsonPropertyOrder(value={"user", "nameInEnglish", "descriptionInEnglish", "price", "itinerary", "pricingType", "type", "perUseQuantity", "beneficiaryList", "payable", "policy", "externalIdentifier", "dailyRateList", "totalPrice"})
public class RawSupplierContractItem {
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUser user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_PRICE = "price";
    private Moneys price;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private Itinerary itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PER_USE_QUANTITY = "perUseQuantity";
    private Integer perUseQuantity;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<RawBeneficiary> beneficiaryList = new ArrayList<RawBeneficiary>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<RawDailyRate> dailyRateList = null;
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private Moneys totalPrice;

    public RawSupplierContractItem user(BookingUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUser user) {
        this.user = user;
    }

    public RawSupplierContractItem nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Deluxe King", required=true, value="Name of item in English included in booking.")
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public RawSupplierContractItem descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="This is the best deluxe king that money can buy.", required=true, value="Short description in English of item included in booking.")
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public RawSupplierContractItem price(Moneys price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(Moneys price) {
        this.price = price;
    }

    public RawSupplierContractItem itinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Itinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
    }

    public RawSupplierContractItem pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Indicates the way this item should be priced.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public RawSupplierContractItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LODGING", required=true, value="Type of item this is.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RawSupplierContractItem perUseQuantity(Integer perUseQuantity) {
        this.perUseQuantity = perUseQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Required when pricing type is PER_USE or PER_PERSON_PER_HOUR. PER_USE => specify how many usages. PER_PERSON_PER_HOUR => specify how many hours")
    @JsonProperty(value="perUseQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerUseQuantity() {
        return this.perUseQuantity;
    }

    @JsonProperty(value="perUseQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerUseQuantity(Integer perUseQuantity) {
        this.perUseQuantity = perUseQuantity;
    }

    public RawSupplierContractItem beneficiaryList(List<RawBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public RawSupplierContractItem addBeneficiaryListItem(RawBeneficiary beneficiaryListItem) {
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawBeneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<RawBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public RawSupplierContractItem payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PREPAY", required=true, value="When to charge for this item.")
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public RawSupplierContractItem policy(SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public RawSupplierContractItem externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="room-type-1", value="Optional reference externalIdentifier to remote inventory.")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public RawSupplierContractItem dailyRateList(List<RawDailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public RawSupplierContractItem addDailyRateListItem(RawDailyRate dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<RawDailyRate>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RawDailyRate> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<RawDailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public RawSupplierContractItem totalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawSupplierContractItem rawSupplierContractItem = (RawSupplierContractItem)o;
        return Objects.equals(this.user, rawSupplierContractItem.user) && Objects.equals(this.nameInEnglish, rawSupplierContractItem.nameInEnglish) && Objects.equals(this.descriptionInEnglish, rawSupplierContractItem.descriptionInEnglish) && Objects.equals(this.price, rawSupplierContractItem.price) && Objects.equals(this.itinerary, rawSupplierContractItem.itinerary) && Objects.equals((Object)this.pricingType, (Object)rawSupplierContractItem.pricingType) && Objects.equals((Object)this.type, (Object)rawSupplierContractItem.type) && Objects.equals(this.perUseQuantity, rawSupplierContractItem.perUseQuantity) && Objects.equals(this.beneficiaryList, rawSupplierContractItem.beneficiaryList) && Objects.equals((Object)this.payable, (Object)rawSupplierContractItem.payable) && Objects.equals(this.policy, rawSupplierContractItem.policy) && Objects.equals(this.externalIdentifier, rawSupplierContractItem.externalIdentifier) && Objects.equals(this.dailyRateList, rawSupplierContractItem.dailyRateList) && Objects.equals(this.totalPrice, rawSupplierContractItem.totalPrice);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.nameInEnglish, this.descriptionInEnglish, this.price, this.itinerary, this.pricingType, this.type, this.perUseQuantity, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.dailyRateList, this.totalPrice});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawSupplierContractItem {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    perUseQuantity: ").append(this.toIndentedString(this.perUseQuantity)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        ADULT("PER_ADULT"),
        CHILD("PER_CHILD"),
        NIGHT("PER_NIGHT"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR"),
        PERSON_PER_STAY("PER_PERSON_PER_STAY"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_STAY("PER_ADULT_PER_STAY"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_STAY("PER_CHILD_PER_STAY"),
        USE("PER_USE"),
        PERSON_PER_USE("PER_PERSON_PER_USE");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

