/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.payment.model.Moneys;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Beneficiary is a registered account with rights to compensation within a booking.
 */
@ApiModel(description = "Beneficiary is a registered account with rights to compensation within a booking.")
@JsonPropertyOrder({
  Beneficiary.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  Beneficiary.JSON_PROPERTY_ACCOUNT_NAME,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY,
  Beneficiary.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-11T13:46:37.093025+07:00[Asia/Bangkok]")
public class Beneficiary {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private String accountIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
  private Moneys amountDueInSourceCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
  private Moneys amountDueInDisplayCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
  private Moneys amountDueInSupplierCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
  private Moneys amountDueInInternalCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
  private Moneys amountDueInCaptureCurrency;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    SALE("SALE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public Beneficiary() { 
  }

  public Beneficiary accountIdentifier(String accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * accountIdentifier of beneficiary that can map to an account with us
   * @return accountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "account-1", required = true, value = "accountIdentifier of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(String accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public Beneficiary accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * accountName of beneficiary that can map to an account with us
   * @return accountName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Account 1", required = true, value = "accountName of beneficiary that can map to an account with us")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountName() {
    return accountName;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public Beneficiary amountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
    
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    return this;
  }

   /**
   * Get amountDueInSourceCurrency
   * @return amountDueInSourceCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInSourceCurrency() {
    return amountDueInSourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
  }


  public Beneficiary amountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
    
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    return this;
  }

   /**
   * Get amountDueInDisplayCurrency
   * @return amountDueInDisplayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInDisplayCurrency() {
    return amountDueInDisplayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
  }


  public Beneficiary amountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
    
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    return this;
  }

   /**
   * Get amountDueInSupplierCurrency
   * @return amountDueInSupplierCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInSupplierCurrency() {
    return amountDueInSupplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
  }


  public Beneficiary amountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
    
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    return this;
  }

   /**
   * Get amountDueInInternalCurrency
   * @return amountDueInInternalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInInternalCurrency() {
    return amountDueInInternalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
  }


  public Beneficiary amountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
    
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    return this;
  }

   /**
   * Get amountDueInCaptureCurrency
   * @return amountDueInCaptureCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInCaptureCurrency() {
    return amountDueInCaptureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
  }


  public Beneficiary type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "The type of beneficiary payment.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Beneficiary beneficiary = (Beneficiary) o;
    return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) &&
        Objects.equals(this.accountName, beneficiary.accountName) &&
        Objects.equals(this.amountDueInSourceCurrency, beneficiary.amountDueInSourceCurrency) &&
        Objects.equals(this.amountDueInDisplayCurrency, beneficiary.amountDueInDisplayCurrency) &&
        Objects.equals(this.amountDueInSupplierCurrency, beneficiary.amountDueInSupplierCurrency) &&
        Objects.equals(this.amountDueInInternalCurrency, beneficiary.amountDueInInternalCurrency) &&
        Objects.equals(this.amountDueInCaptureCurrency, beneficiary.amountDueInCaptureCurrency) &&
        Objects.equals(this.type, beneficiary.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentifier, accountName, amountDueInSourceCurrency, amountDueInDisplayCurrency, amountDueInSupplierCurrency, amountDueInInternalCurrency, amountDueInCaptureCurrency, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Beneficiary {\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    amountDueInSourceCurrency: ").append(toIndentedString(amountDueInSourceCurrency)).append("\n");
    sb.append("    amountDueInDisplayCurrency: ").append(toIndentedString(amountDueInDisplayCurrency)).append("\n");
    sb.append("    amountDueInSupplierCurrency: ").append(toIndentedString(amountDueInSupplierCurrency)).append("\n");
    sb.append("    amountDueInInternalCurrency: ").append(toIndentedString(amountDueInInternalCurrency)).append("\n");
    sb.append("    amountDueInCaptureCurrency: ").append(toIndentedString(amountDueInCaptureCurrency)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

