package travel.wink.sdk.payment.api;

import travel.wink.sdk.payment.invoker.ApiClient;

import travel.wink.sdk.payment.model.Account;
import travel.wink.sdk.payment.model.CreateAccountRequest;
import travel.wink.sdk.payment.model.CreateBankAccountRequest;
import travel.wink.sdk.payment.model.CreateIntegrationRequest;
import travel.wink.sdk.payment.model.KeyValuePair;
import travel.wink.sdk.payment.model.RemoveEntryResponse;
import travel.wink.sdk.payment.model.SendInvitationRequest;
import travel.wink.sdk.payment.model.SendInvitationResponse;
import travel.wink.sdk.payment.model.UniqueResult;
import travel.wink.sdk.payment.model.UpdateAccountRequest;
import travel.wink.sdk.payment.model.UpdateBankAccountRequest;
import travel.wink.sdk.payment.model.UpdateIntegrationRequest;
import travel.wink.sdk.payment.model.VerifyAccountRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:47:55.024323+07:00[Asia/Bangkok]")
public class AccountApi {
    private ApiClient apiClient;

    public AccountApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Send KYC email
     * Starts / Re-starts account verification workflow.
     * <p><b>200</b> - OK
     * @param sendInvitationRequest The sendInvitationRequest parameter
     * @return SendInvitationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec beginKYCPathRequestCreation(SendInvitationRequest sendInvitationRequest) throws WebClientResponseException {
        Object postBody = sendInvitationRequest;
        // verify the required parameter 'sendInvitationRequest' is set
        if (sendInvitationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'sendInvitationRequest' when calling beginKYCPath", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SendInvitationResponse> localVarReturnType = new ParameterizedTypeReference<SendInvitationResponse>() {};
        return apiClient.invokeAPI("/api/account/invite", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Send KYC email
     * Starts / Re-starts account verification workflow.
     * <p><b>200</b> - OK
     * @param sendInvitationRequest The sendInvitationRequest parameter
     * @return SendInvitationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SendInvitationResponse> beginKYCPath(SendInvitationRequest sendInvitationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SendInvitationResponse> localVarReturnType = new ParameterizedTypeReference<SendInvitationResponse>() {};
        return beginKYCPathRequestCreation(sendInvitationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SendInvitationResponse>> beginKYCPathWithHttpInfo(SendInvitationRequest sendInvitationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SendInvitationResponse> localVarReturnType = new ParameterizedTypeReference<SendInvitationResponse>() {};
        return beginKYCPathRequestCreation(sendInvitationRequest).toEntity(localVarReturnType);
    }
    /**
     * Create Account
     * Create a new account
     * <p><b>200</b> - OK
     * @param createAccountRequest The createAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountRequestCreation(CreateAccountRequest createAccountRequest) throws WebClientResponseException {
        Object postBody = createAccountRequest;
        // verify the required parameter 'createAccountRequest' is set
        if (createAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAccountRequest' when calling createAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account
     * Create a new account
     * <p><b>200</b> - OK
     * @param createAccountRequest The createAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccount(CreateAccountRequest createAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountRequestCreation(createAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountWithHttpInfo(CreateAccountRequest createAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountRequestCreation(createAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Add Bank Account
     * Add a bank account to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createBankAccountRequest The createBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountBankAccountRequestCreation(String id, CreateBankAccountRequest createBankAccountRequest) throws WebClientResponseException {
        Object postBody = createBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createBankAccountRequest' is set
        if (createBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createBankAccountRequest' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/bankaccount", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Bank Account
     * Add a bank account to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createBankAccountRequest The createBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccountBankAccount(String id, CreateBankAccountRequest createBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountBankAccountRequestCreation(id, createBankAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountBankAccountWithHttpInfo(String id, CreateBankAccountRequest createBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountBankAccountRequestCreation(id, createBankAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Add Integration
     * Add a integration to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createIntegrationRequest The createIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountIntegrationRequestCreation(String id, CreateIntegrationRequest createIntegrationRequest) throws WebClientResponseException {
        Object postBody = createIntegrationRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createIntegrationRequest' is set
        if (createIntegrationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createIntegrationRequest' when calling createAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/integration", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Integration
     * Add a integration to an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createIntegrationRequest The createIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccountIntegration(String id, CreateIntegrationRequest createIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountIntegrationRequestCreation(id, createIntegrationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountIntegrationWithHttpInfo(String id, CreateIntegrationRequest createIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountIntegrationRequestCreation(id, createIntegrationRequest).toEntity(localVarReturnType);
    }
    /**
     * Add Bank Account to External
     * Add a bank account to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createBankAccountRequest The createBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createExternalAccountBankAccountRequestCreation(String id, CreateBankAccountRequest createBankAccountRequest) throws WebClientResponseException {
        Object postBody = createBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createBankAccountRequest' is set
        if (createBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createBankAccountRequest' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/bankaccount", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Bank Account to External
     * Add a bank account to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createBankAccountRequest The createBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createExternalAccountBankAccount(String id, CreateBankAccountRequest createBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createExternalAccountBankAccountRequestCreation(id, createBankAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createExternalAccountBankAccountWithHttpInfo(String id, CreateBankAccountRequest createBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createExternalAccountBankAccountRequestCreation(id, createBankAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Add Integration to External
     * Add a integration to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createIntegrationRequest The createIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createExternalAccountIntegrationRequestCreation(String id, CreateIntegrationRequest createIntegrationRequest) throws WebClientResponseException {
        Object postBody = createIntegrationRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createIntegrationRequest' is set
        if (createIntegrationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createIntegrationRequest' when calling createExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/integration", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Integration to External
     * Add a integration to an existing account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param createIntegrationRequest The createIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createExternalAccountIntegration(String id, CreateIntegrationRequest createIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createExternalAccountIntegrationRequestCreation(id, createIntegrationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createExternalAccountIntegrationWithHttpInfo(String id, CreateIntegrationRequest createIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createExternalAccountIntegrationRequestCreation(id, createIntegrationRequest).toEntity(localVarReturnType);
    }
    /**
     * Delete Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteAccountRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/account/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> deleteAccount(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteAccountRequestCreation(id, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> deleteAccountWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteAccountRequestCreation(id, accept).toEntity(localVarReturnType);
    }
    /**
     * Verify Account Name
     * Check if account name is unique
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param identifier The identifier parameter
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isAccountNameUniqueRequestCreation(String name, String identifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling isAccountNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("name", name);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "identifier", identifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return apiClient.invokeAPI("/api/account/unique/{name}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Account Name
     * Check if account name is unique
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param identifier The identifier parameter
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResult> isAccountNameUnique(String name, String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isAccountNameUniqueRequestCreation(name, identifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isAccountNameUniqueWithHttpInfo(String name, String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isAccountNameUniqueRequestCreation(name, identifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountRequestCreation(String id, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account
     * Show a specific account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> loadAccount(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountRequestCreation(id, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> loadAccountWithHttpInfo(String id, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountRequestCreation(id, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountByNameRequestCreation(String name, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("name", name);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/name/{name}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> loadAccountByName(String name, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountByNameRequestCreation(name, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountByNameWithHttpInfo(String name, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountByNameRequestCreation(name, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Account for User
     * Load account details for authenticated user
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountsForAuthenticatedUserRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account for User
     * Load account details for authenticated user
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> loadAccountsForAuthenticatedUser(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountsForAuthenticatedUserRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountsForAuthenticatedUserWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadAccountsForAuthenticatedUserRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Account for External
     * Show a specific account by passing your own external identifier
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier The externalAccountIdentifier parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadExternalAccountRequestCreation(String externalAccountIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'externalAccountIdentifier' is set
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling loadExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account for External
     * Show a specific account by passing your own external identifier
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier The externalAccountIdentifier parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> loadExternalAccount(String externalAccountIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadExternalAccountRequestCreation(externalAccountIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> loadExternalAccountWithHttpInfo(String externalAccountIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return loadExternalAccountRequestCreation(externalAccountIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Remove Bank Account
     * Remove an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountBankAccountRequestCreation(String id, String bankAccountId, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/bankaccount/{bankAccountId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Bank Account
     * Remove an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeAccountBankAccount(String id, String bankAccountId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountBankAccountRequestCreation(id, bankAccountId, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountBankAccountWithHttpInfo(String id, String bankAccountId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountBankAccountRequestCreation(id, bankAccountId, accept).toEntity(localVarReturnType);
    }
    /**
     * Remove Integration
     * Remove an existing integration for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountIntegrationRequestCreation(String id, String integrationId, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new WebClientResponseException("Missing the required parameter 'integrationId' when calling removeAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("integrationId", integrationId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/integration/{integrationId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Integration
     * Remove an existing integration for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeAccountIntegration(String id, String integrationId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountIntegrationRequestCreation(id, integrationId, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountIntegrationWithHttpInfo(String id, String integrationId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountIntegrationRequestCreation(id, integrationId, accept).toEntity(localVarReturnType);
    }
    /**
     * Remove Bank Account for External
     * Remove an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeExternalAccountBankAccountRequestCreation(String id, String bankAccountId, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/bankaccount/{bankAccountId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Bank Account for External
     * Remove an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeExternalAccountBankAccount(String id, String bankAccountId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeExternalAccountBankAccountRequestCreation(id, bankAccountId, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeExternalAccountBankAccountWithHttpInfo(String id, String bankAccountId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeExternalAccountBankAccountRequestCreation(id, bankAccountId, accept).toEntity(localVarReturnType);
    }
    /**
     * Remove Integration from External
     * Remove an existing integration for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeExternalAccountIntegrationRequestCreation(String id, String integrationId, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new WebClientResponseException("Missing the required parameter 'integrationId' when calling removeExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("integrationId", integrationId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/integration/{integrationId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Integration from External
     * Remove an existing integration for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeExternalAccountIntegration(String id, String integrationId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeExternalAccountIntegrationRequestCreation(id, integrationId, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeExternalAccountIntegrationWithHttpInfo(String id, String integrationId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeExternalAccountIntegrationRequestCreation(id, integrationId, accept).toEntity(localVarReturnType);
    }
    /**
     * Search Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignorecase The ignorecase parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchAccountByNameRequestCreation(String name, Boolean ignorecase, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling searchAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("name", name);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ignorecase", ignorecase));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/account/search/{name}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Accounts by Name
     * Show accounts matching name
     * <p><b>200</b> - OK
     * @param name The name parameter
     * @param ignorecase The ignorecase parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> searchAccountByName(String name, Boolean ignorecase, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return searchAccountByNameRequestCreation(name, ignorecase, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> searchAccountByNameWithHttpInfo(String name, Boolean ignorecase, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return searchAccountByNameRequestCreation(name, ignorecase, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Accounts by Owner
     * List all accounts owned by creating entity
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAccountsByOwnerRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/owner/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Accounts by Owner
     * List all accounts owned by creating entity
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;Account&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Account> showAccountsByOwner(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return showAccountsByOwnerRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> showAccountsByOwnerWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return showAccountsByOwnerRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Account
     * Update an existing account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountRequest The updateAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountRequestCreation(String id, UpdateAccountRequest updateAccountRequest) throws WebClientResponseException {
        Object postBody = updateAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateAccountRequest' is set
        if (updateAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountRequest' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account
     * Update an existing account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountRequest The updateAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccount(String id, UpdateAccountRequest updateAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountRequestCreation(id, updateAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountWithHttpInfo(String id, UpdateAccountRequest updateAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountRequestCreation(id, updateAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Update External Account
     * Update an existing account using the externalIdentifier to find the account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountRequest The updateAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateExternalAccountRequestCreation(String id, UpdateAccountRequest updateAccountRequest) throws WebClientResponseException {
        Object postBody = updateAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateAccountRequest' is set
        if (updateAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountRequest' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update External Account
     * Update an existing account using the externalIdentifier to find the account
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountRequest The updateAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateExternalAccount(String id, UpdateAccountRequest updateAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateExternalAccountRequestCreation(id, updateAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateExternalAccountWithHttpInfo(String id, UpdateAccountRequest updateAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateExternalAccountRequestCreation(id, updateAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Bank Account
     * Update an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param updateBankAccountRequest The updateBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertAccountBankAccountRequestCreation(String id, String bankAccountId, UpdateBankAccountRequest updateBankAccountRequest) throws WebClientResponseException {
        Object postBody = updateBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateBankAccountRequest' is set
        if (updateBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateBankAccountRequest' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/bankaccount/{bankAccountId}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Bank Account
     * Update an existing bank account for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param updateBankAccountRequest The updateBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> upsertAccountBankAccount(String id, String bankAccountId, UpdateBankAccountRequest updateBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertAccountBankAccountRequestCreation(id, bankAccountId, updateBankAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertAccountBankAccountWithHttpInfo(String id, String bankAccountId, UpdateBankAccountRequest updateBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertAccountBankAccountRequestCreation(id, bankAccountId, updateBankAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Integration
     * Update an existing integration for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param updateIntegrationRequest The updateIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertAccountIntegrationRequestCreation(String id, String integrationId, UpdateIntegrationRequest updateIntegrationRequest) throws WebClientResponseException {
        Object postBody = updateIntegrationRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new WebClientResponseException("Missing the required parameter 'integrationId' when calling upsertAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateIntegrationRequest' is set
        if (updateIntegrationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateIntegrationRequest' when calling upsertAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("integrationId", integrationId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/integration/{integrationId}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Integration
     * Update an existing integration for an existing account using local account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param updateIntegrationRequest The updateIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> upsertAccountIntegration(String id, String integrationId, UpdateIntegrationRequest updateIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertAccountIntegrationRequestCreation(id, integrationId, updateIntegrationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertAccountIntegrationWithHttpInfo(String id, String integrationId, UpdateIntegrationRequest updateIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertAccountIntegrationRequestCreation(id, integrationId, updateIntegrationRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Bank Account for External
     * Update an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param updateBankAccountRequest The updateBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertExternalAccountBankAccountRequestCreation(String id, String bankAccountId, UpdateBankAccountRequest updateBankAccountRequest) throws WebClientResponseException {
        Object postBody = updateBankAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bankAccountId' is set
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateBankAccountRequest' is set
        if (updateBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateBankAccountRequest' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/bankaccount/{bankAccountId}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Bank Account for External
     * Update an existing bank account for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param bankAccountId The bankAccountId parameter
     * @param updateBankAccountRequest The updateBankAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> upsertExternalAccountBankAccount(String id, String bankAccountId, UpdateBankAccountRequest updateBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, updateBankAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertExternalAccountBankAccountWithHttpInfo(String id, String bankAccountId, UpdateBankAccountRequest updateBankAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, updateBankAccountRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Integration for External
     * Update an existing integration for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param updateIntegrationRequest The updateIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertExternalAccountIntegrationRequestCreation(String id, String integrationId, UpdateIntegrationRequest updateIntegrationRequest) throws WebClientResponseException {
        Object postBody = updateIntegrationRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new WebClientResponseException("Missing the required parameter 'integrationId' when calling upsertExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateIntegrationRequest' is set
        if (updateIntegrationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateIntegrationRequest' when calling upsertExternalAccountIntegration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("integrationId", integrationId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/external/{id}/integration/{integrationId}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Integration for External
     * Update an existing integration for an account using the external account identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param integrationId The integrationId parameter
     * @param updateIntegrationRequest The updateIntegrationRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> upsertExternalAccountIntegration(String id, String integrationId, UpdateIntegrationRequest updateIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertExternalAccountIntegrationRequestCreation(id, integrationId, updateIntegrationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertExternalAccountIntegrationWithHttpInfo(String id, String integrationId, UpdateIntegrationRequest updateIntegrationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return upsertExternalAccountIntegrationRequestCreation(id, integrationId, updateIntegrationRequest).toEntity(localVarReturnType);
    }
    /**
     * Verify Account
     * Enriches account with supplemental data that missing in the account creation phase.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param verifyAccountRequest The verifyAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec verifyAccountRequestCreation(String id, VerifyAccountRequest verifyAccountRequest) throws WebClientResponseException {
        Object postBody = verifyAccountRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'verifyAccountRequest' is set
        if (verifyAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'verifyAccountRequest' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/account/{id}/verify", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Account
     * Enriches account with supplemental data that missing in the account creation phase.
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param verifyAccountRequest The verifyAccountRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> verifyAccount(String id, VerifyAccountRequest verifyAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return verifyAccountRequestCreation(id, verifyAccountRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> verifyAccountWithHttpInfo(String id, VerifyAccountRequest verifyAccountRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return verifyAccountRequestCreation(id, verifyAccountRequest).toEntity(localVarReturnType);
    }
}
