/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.payment.model.CompositeFilterDescriptor;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Descriptors used for filtering result set
 */
@ApiModel(description = "Descriptors used for filtering result set")
@JsonPropertyOrder({
  FilterDescriptor.JSON_PROPERTY_LOGIC,
  FilterDescriptor.JSON_PROPERTY_FILTERS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:47:55.024323+07:00[Asia/Bangkok]")
public class FilterDescriptor {
  /**
   * Whether to filter inclusively or exclusively
   */
  public enum LogicEnum {
    AND("and"),
    
    OR("or");

    private String value;

    LogicEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LogicEnum fromValue(String value) {
      for (LogicEnum b : LogicEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LOGIC = "logic";
  private LogicEnum logic;

  public static final String JSON_PROPERTY_FILTERS = "filters";
  private List<CompositeFilterDescriptor> filters = null;

  public FilterDescriptor() { 
  }

  public FilterDescriptor logic(LogicEnum logic) {
    
    this.logic = logic;
    return this;
  }

   /**
   * Whether to filter inclusively or exclusively
   * @return logic
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "and", value = "Whether to filter inclusively or exclusively")
  @JsonProperty(JSON_PROPERTY_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LogicEnum getLogic() {
    return logic;
  }


  @JsonProperty(JSON_PROPERTY_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogic(LogicEnum logic) {
    this.logic = logic;
  }


  public FilterDescriptor filters(List<CompositeFilterDescriptor> filters) {
    
    this.filters = filters;
    return this;
  }

  public FilterDescriptor addFiltersItem(CompositeFilterDescriptor filtersItem) {
    if (this.filters == null) {
      this.filters = new ArrayList<>();
    }
    this.filters.add(filtersItem);
    return this;
  }

   /**
   * Descriptors used for filtering the result set
   * @return filters
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Descriptors used for filtering the result set")
  @JsonProperty(JSON_PROPERTY_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CompositeFilterDescriptor> getFilters() {
    return filters;
  }


  @JsonProperty(JSON_PROPERTY_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilters(List<CompositeFilterDescriptor> filters) {
    this.filters = filters;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterDescriptor filterDescriptor = (FilterDescriptor) o;
    return Objects.equals(this.logic, filterDescriptor.logic) &&
        Objects.equals(this.filters, filterDescriptor.filters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(logic, filters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterDescriptor {\n");
    sb.append("    logic: ").append(toIndentedString(logic)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

