/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CancelBookingContractRequest
 */
@JsonPropertyOrder({
  CancelBookingContractRequest.JSON_PROPERTY_CANCELLER_TYPE,
  CancelBookingContractRequest.JSON_PROPERTY_TYPE,
  CancelBookingContractRequest.JSON_PROPERTY_REASON
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-29T13:21:24.200164+07:00[Asia/Bangkok]")
public class CancelBookingContractRequest {
  /**
   * Who is doing the cancellation
   */
  public enum CancellerTypeEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER");

    private String value;

    CancellerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerTypeEnum fromValue(String value) {
      for (CancellerTypeEnum b : CancellerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER_TYPE = "cancellerType";
  private CancellerTypeEnum cancellerType;

  /**
   * Type of cancellation
   */
  public enum TypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  public CancelBookingContractRequest() { 
  }

  @JsonCreator
  public CancelBookingContractRequest(
    @JsonProperty(JSON_PROPERTY_CANCELLER_TYPE) CancellerTypeEnum cancellerType, 
    @JsonProperty(JSON_PROPERTY_TYPE) TypeEnum type, 
    @JsonProperty(JSON_PROPERTY_REASON) String reason
  ) {
    this();
    this.cancellerType = cancellerType;
    this.type = type;
    this.reason = reason;
  }

   /**
   * Who is doing the cancellation
   * @return cancellerType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "SUPPLIER", required = true, value = "Who is doing the cancellation")
  @JsonProperty(JSON_PROPERTY_CANCELLER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellerTypeEnum getCancellerType() {
    return cancellerType;
  }




   /**
   * Type of cancellation
   * @return type
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "NO_SHOW", required = true, value = "Type of cancellation")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }




   /**
   * Reason for cancellation
   * @return reason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason for cancellation")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReason() {
    return reason;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancelBookingContractRequest cancelBookingContractRequest = (CancelBookingContractRequest) o;
    return Objects.equals(this.cancellerType, cancelBookingContractRequest.cancellerType) &&
        Objects.equals(this.type, cancelBookingContractRequest.type) &&
        Objects.equals(this.reason, cancelBookingContractRequest.reason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cancellerType, type, reason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancelBookingContractRequest {\n");
    sb.append("    cancellerType: ").append(toIndentedString(cancellerType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

