/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"localAccountIdentifier", "externalIdentifier", "accountIdentifier", "name"})
public class CreateMappingRequest {
    public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
    private String localAccountIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private String accountIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public CreateMappingRequest() {
    }

    @JsonCreator
    public CreateMappingRequest(@JsonProperty(value="localAccountIdentifier") String localAccountIdentifier, @JsonProperty(value="externalIdentifier") String externalIdentifier, @JsonProperty(value="accountIdentifier") String accountIdentifier, @JsonProperty(value="name") String name) {
        this();
        this.localAccountIdentifier = localAccountIdentifier;
        this.externalIdentifier = externalIdentifier;
        this.accountIdentifier = accountIdentifier;
        this.name = name;
    }

    @Nonnull
    @ApiModelProperty(example="hotel-1", required=true, value="Local account identifier is the payment identifier")
    @JsonProperty(value="localAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocalAccountIdentifier() {
        return this.localAccountIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="hotel-a", required=true, value="External identifier is the identifier of this entity in a remote system")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="account-1", required=true, value="Account identifier is the account doing the mapping")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="Sheraton Hua Hin", required=true, value="Name of the entity being mapped")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMappingRequest createMappingRequest = (CreateMappingRequest)o;
        return Objects.equals(this.localAccountIdentifier, createMappingRequest.localAccountIdentifier) && Objects.equals(this.externalIdentifier, createMappingRequest.externalIdentifier) && Objects.equals(this.accountIdentifier, createMappingRequest.accountIdentifier) && Objects.equals(this.name, createMappingRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.localAccountIdentifier, this.externalIdentifier, this.accountIdentifier, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMappingRequest {\n");
        sb.append("    localAccountIdentifier: ").append(this.toIndentedString(this.localAccountIdentifier)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

