/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.payment.model.Acquirer;
import travel.wink.sdk.payment.model.Address;
import travel.wink.sdk.payment.model.BankAccount;
import travel.wink.sdk.payment.model.Integration;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Account holds KYC, bank account and contact information of an affiliate, supplier, payment or any type of entity that is to be a beneficiary of funds through the payment.
 */
@ApiModel(description = "Account holds KYC, bank account and contact information of an affiliate, supplier, payment or any type of entity that is to be a beneficiary of funds through the payment.")
@JsonPropertyOrder({
  Account.JSON_PROPERTY_ID,
  Account.JSON_PROPERTY_CREATED_DATE,
  Account.JSON_PROPERTY_LAST_UPDATE,
  Account.JSON_PROPERTY_VERSION,
  Account.JSON_PROPERTY_TYPE,
  Account.JSON_PROPERTY_OWNER_TYPE,
  Account.JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER,
  Account.JSON_PROPERTY_NAME,
  Account.JSON_PROPERTY_USER_IDENTIFIER,
  Account.JSON_PROPERTY_ACCOUNT_EMAIL,
  Account.JSON_PROPERTY_DESCRIPTION,
  Account.JSON_PROPERTY_URL,
  Account.JSON_PROPERTY_STATUS,
  Account.JSON_PROPERTY_CURRENCY_CODE,
  Account.JSON_PROPERTY_ADDRESS,
  Account.JSON_PROPERTY_INTEGRATIONS,
  Account.JSON_PROPERTY_ACQUIRERS,
  Account.JSON_PROPERTY_BANK_ACCOUNTS,
  Account.JSON_PROPERTY_OWNER_TYPE_IDENTIFIER,
  Account.JSON_PROPERTY_DOB
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:01:23.504311+07:00[Asia/Bangkok]")
public class Account {
  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private OffsetDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private OffsetDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  /**
   * Type of account tells us what the account is capable of.
   */
  public enum TypeEnum {
    MERCHANT("MERCHANT"),
    
    AFFILIATE("AFFILIATE"),
    
    AGENT("AGENT"),
    
    FACILITATOR("FACILITATOR");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Type of account owner tells us whether ths account is managed by a company or an individual.
   */
  public enum OwnerTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER = "accountOwnerIdentifier";
  private UUID accountOwnerIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
  private String accountEmail;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  /**
   * Account status shows if it&#39;s approved
   */
  public enum StatusEnum {
    REGISTERED("REGISTERED"),
    
    VERIFICATION_EMAIL_SENT("VERIFICATION_EMAIL_SENT"),
    
    APPROVED("APPROVED"),
    
    DEACTIVATED("DEACTIVATED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status = StatusEnum.REGISTERED;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_INTEGRATIONS = "integrations";
  private List<Integration> integrations = null;

  public static final String JSON_PROPERTY_ACQUIRERS = "acquirers";
  private List<Acquirer> acquirers = null;

  public static final String JSON_PROPERTY_BANK_ACCOUNTS = "bankAccounts";
  private List<BankAccount> bankAccounts = null;

  public static final String JSON_PROPERTY_OWNER_TYPE_IDENTIFIER = "ownerTypeIdentifier";
  private String ownerTypeIdentifier;

  public static final String JSON_PROPERTY_DOB = "dob";
  private OffsetDateTime dob;

  public Account() { 
  }

  public Account id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Document UUID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(UUID id) {
    this.id = id;
  }


  public Account createdDate(OffsetDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was first created")
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(OffsetDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public Account lastUpdate(OffsetDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was last updated")
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(OffsetDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public Account version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12", value = "Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public Account type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of account tells us what the account is capable of.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "MERCHANT", required = true, value = "Type of account tells us what the account is capable of.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Account ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * Type of account owner tells us whether ths account is managed by a company or an individual.
   * @return ownerType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "COMPANY", required = true, value = "Type of account owner tells us whether ths account is managed by a company or an individual.")
  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public Account accountOwnerIdentifier(UUID accountOwnerIdentifier) {
    
    this.accountOwnerIdentifier = accountOwnerIdentifier;
    return this;
  }

   /**
   * The entity that created this account.
   * @return accountOwnerIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The entity that created this account.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAccountOwnerIdentifier() {
    return accountOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountOwnerIdentifier(UUID accountOwnerIdentifier) {
    this.accountOwnerIdentifier = accountOwnerIdentifier;
  }


  public Account name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company / full name of person
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My Company", required = true, value = "Name of company / full name of person")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Account userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * The authenticated user that owns this account.
   * @return userIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The authenticated user that owns this account.")
  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public Account accountEmail(String accountEmail) {
    
    this.accountEmail = accountEmail;
    return this;
  }

   /**
   * Account email is where we will send KYC documents and other account specific mailings
   * @return accountEmail
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "company@acme.com", required = true, value = "Account email is where we will send KYC documents and other account specific mailings")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountEmail() {
    return accountEmail;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountEmail(String accountEmail) {
    this.accountEmail = accountEmail;
  }


  public Account description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Short company / person description.
   * @return description
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My Company is the best company ever.", required = true, value = "Short company / person description.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Account url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company website. If private person with no personal website, link to main social network account.
   * @return url
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://trippay.io", required = true, value = "Company website. If private person with no personal website, link to main social network account.")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public Account status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Account status shows if it&#39;s approved
   * @return status
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "APPROVED", required = true, value = "Account status shows if it's approved")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Account currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Account&#39;s main currency.
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=3,max=3)  @ApiModelProperty(example = "GBP", required = true, value = "Account's main currency.")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public Account address(Address address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public Account integrations(List<Integration> integrations) {
    
    this.integrations = integrations;
    return this;
  }

  public Account addIntegrationsItem(Integration integrationsItem) {
    if (this.integrations == null) {
      this.integrations = new ArrayList<>();
    }
    this.integrations.add(integrationsItem);
    return this;
  }

   /**
   * Get integrations
   * @return integrations
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTEGRATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integration> getIntegrations() {
    return integrations;
  }


  @JsonProperty(JSON_PROPERTY_INTEGRATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIntegrations(List<Integration> integrations) {
    this.integrations = integrations;
  }


  public Account acquirers(List<Acquirer> acquirers) {
    
    this.acquirers = acquirers;
    return this;
  }

  public Account addAcquirersItem(Acquirer acquirersItem) {
    if (this.acquirers == null) {
      this.acquirers = new ArrayList<>();
    }
    this.acquirers.add(acquirersItem);
    return this;
  }

   /**
   * Get acquirers
   * @return acquirers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACQUIRERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Acquirer> getAcquirers() {
    return acquirers;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirers(List<Acquirer> acquirers) {
    this.acquirers = acquirers;
  }


  public Account bankAccounts(List<BankAccount> bankAccounts) {
    
    this.bankAccounts = bankAccounts;
    return this;
  }

  public Account addBankAccountsItem(BankAccount bankAccountsItem) {
    if (this.bankAccounts == null) {
      this.bankAccounts = new ArrayList<>();
    }
    this.bankAccounts.add(bankAccountsItem);
    return this;
  }

   /**
   * Get bankAccounts
   * @return bankAccounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BankAccount> getBankAccounts() {
    return bankAccounts;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccounts(List<BankAccount> bankAccounts) {
    this.bankAccounts = bankAccounts;
  }


  public Account ownerTypeIdentifier(String ownerTypeIdentifier) {
    
    this.ownerTypeIdentifier = ownerTypeIdentifier;
    return this;
  }

   /**
   * This is the tax identification number (TIN) for individuals and entity identification number (EIN) for companies.
   * @return ownerTypeIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "This is the tax identification number (TIN) for individuals and entity identification number (EIN) for companies.")
  @JsonProperty(JSON_PROPERTY_OWNER_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerTypeIdentifier() {
    return ownerTypeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerTypeIdentifier(String ownerTypeIdentifier) {
    this.ownerTypeIdentifier = ownerTypeIdentifier;
  }


  public Account dob(OffsetDateTime dob) {
    
    this.dob = dob;
    return this;
  }

   /**
   * This is the individual&#39;s date of birth.
   * @return dob
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "This is the individual's date of birth.")
  @JsonProperty(JSON_PROPERTY_DOB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDob() {
    return dob;
  }


  @JsonProperty(JSON_PROPERTY_DOB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDob(OffsetDateTime dob) {
    this.dob = dob;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.id, account.id) &&
        Objects.equals(this.createdDate, account.createdDate) &&
        Objects.equals(this.lastUpdate, account.lastUpdate) &&
        Objects.equals(this.version, account.version) &&
        Objects.equals(this.type, account.type) &&
        Objects.equals(this.ownerType, account.ownerType) &&
        Objects.equals(this.accountOwnerIdentifier, account.accountOwnerIdentifier) &&
        Objects.equals(this.name, account.name) &&
        Objects.equals(this.userIdentifier, account.userIdentifier) &&
        Objects.equals(this.accountEmail, account.accountEmail) &&
        Objects.equals(this.description, account.description) &&
        Objects.equals(this.url, account.url) &&
        Objects.equals(this.status, account.status) &&
        Objects.equals(this.currencyCode, account.currencyCode) &&
        Objects.equals(this.address, account.address) &&
        Objects.equals(this.integrations, account.integrations) &&
        Objects.equals(this.acquirers, account.acquirers) &&
        Objects.equals(this.bankAccounts, account.bankAccounts) &&
        Objects.equals(this.ownerTypeIdentifier, account.ownerTypeIdentifier) &&
        Objects.equals(this.dob, account.dob);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, type, ownerType, accountOwnerIdentifier, name, userIdentifier, accountEmail, description, url, status, currencyCode, address, integrations, acquirers, bankAccounts, ownerTypeIdentifier, dob);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    accountOwnerIdentifier: ").append(toIndentedString(accountOwnerIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    accountEmail: ").append(toIndentedString(accountEmail)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    integrations: ").append(toIndentedString(integrations)).append("\n");
    sb.append("    acquirers: ").append(toIndentedString(acquirers)).append("\n");
    sb.append("    bankAccounts: ").append(toIndentedString(bankAccounts)).append("\n");
    sb.append("    ownerTypeIdentifier: ").append(toIndentedString(ownerTypeIdentifier)).append("\n");
    sb.append("    dob: ").append(toIndentedString(dob)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

