/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Mapping record is responsible for mapping a local account identifier with a remote system. When a booking comes in from the remote system, we will know how to properly assign funds to the correct accounts.
 */
@ApiModel(description = "Mapping record is responsible for mapping a local account identifier with a remote system. When a booking comes in from the remote system, we will know how to properly assign funds to the correct accounts.")
@JsonPropertyOrder({
  Mapping.JSON_PROPERTY_ID,
  Mapping.JSON_PROPERTY_CREATED_DATE,
  Mapping.JSON_PROPERTY_LAST_UPDATE,
  Mapping.JSON_PROPERTY_VERSION,
  Mapping.JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER,
  Mapping.JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER,
  Mapping.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  Mapping.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  Mapping.JSON_PROPERTY_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:01:23.504311+07:00[Asia/Bangkok]")
public class Mapping {
  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private OffsetDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private OffsetDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER = "accountOwnerIdentifier";
  private UUID accountOwnerIdentifier;

  public static final String JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER = "localAccountIdentifier";
  private UUID localAccountIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private UUID accountIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public Mapping() { 
  }

  public Mapping id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Document UUID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(UUID id) {
    this.id = id;
  }


  public Mapping createdDate(OffsetDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was first created")
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(OffsetDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public Mapping lastUpdate(OffsetDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was last updated")
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(OffsetDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public Mapping version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12", value = "Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public Mapping accountOwnerIdentifier(UUID accountOwnerIdentifier) {
    
    this.accountOwnerIdentifier = accountOwnerIdentifier;
    return this;
  }

   /**
   * The entity that owns this account.
   * @return accountOwnerIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The entity that owns this account.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAccountOwnerIdentifier() {
    return accountOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountOwnerIdentifier(UUID accountOwnerIdentifier) {
    this.accountOwnerIdentifier = accountOwnerIdentifier;
  }


  public Mapping localAccountIdentifier(UUID localAccountIdentifier) {
    
    this.localAccountIdentifier = localAccountIdentifier;
    return this;
  }

   /**
   * Local account identifier is the payment identifier
   * @return localAccountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Local account identifier is the payment identifier")
  @JsonProperty(JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getLocalAccountIdentifier() {
    return localAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocalAccountIdentifier(UUID localAccountIdentifier) {
    this.localAccountIdentifier = localAccountIdentifier;
  }


  public Mapping externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * External identifier is the identifier of this entity in a remote system
   * @return externalIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "hotel-a", required = true, value = "External identifier is the identifier of this entity in a remote system")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public Mapping accountIdentifier(UUID accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * Account identifier is the account doing the mapping
   * @return accountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Account identifier is the account doing the mapping")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(UUID accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public Mapping name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the entity being mapped
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Sheraton Hua Hin", required = true, value = "Name of the entity being mapped")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Mapping mapping = (Mapping) o;
    return Objects.equals(this.id, mapping.id) &&
        Objects.equals(this.createdDate, mapping.createdDate) &&
        Objects.equals(this.lastUpdate, mapping.lastUpdate) &&
        Objects.equals(this.version, mapping.version) &&
        Objects.equals(this.accountOwnerIdentifier, mapping.accountOwnerIdentifier) &&
        Objects.equals(this.localAccountIdentifier, mapping.localAccountIdentifier) &&
        Objects.equals(this.externalIdentifier, mapping.externalIdentifier) &&
        Objects.equals(this.accountIdentifier, mapping.accountIdentifier) &&
        Objects.equals(this.name, mapping.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, accountOwnerIdentifier, localAccountIdentifier, externalIdentifier, accountIdentifier, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Mapping {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    accountOwnerIdentifier: ").append(toIndentedString(accountOwnerIdentifier)).append("\n");
    sb.append("    localAccountIdentifier: ").append(toIndentedString(localAccountIdentifier)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

