/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.payment.invoker.ApiClient;
import travel.wink.sdk.payment.model.BookingContract;
import travel.wink.sdk.payment.model.BookingContractCancellableResponse;
import travel.wink.sdk.payment.model.CancelBookingContractRequest;

public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelBookingContractRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}/cancel", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContract> cancelBookingContract(String identifier, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> cancelBookingContractWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec cancelGroupBookingContractRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}/cancel", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContract> cancelGroupBookingContract(String traceId, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> cancelGroupBookingContractWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec isContractCancellableRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}/cancellable", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContractCancellableResponse> isContractCancellable(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(){};
        return this.isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContractCancellableResponse>> isContractCancellableWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(){};
        return this.isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec isGroupContractCancellableRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        CancelBookingContractRequest postBody = cancelBookingContractRequest;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}/cancellable", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContractCancellableResponse> isGroupContractCancellable(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(){};
        return this.isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContractCancellableResponse>>> isGroupContractCancellableWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>(){};
        return this.isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showContractRequestCreation(String identifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.apiClient.invokeAPI("/api/contract/{identifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingContract> showContract(String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.showContractRequestCreation(identifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingContract>> showContractWithHttpInfo(String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.showContractRequestCreation(identifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showContractsRequestCreation(String traceId, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling showContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("traceId", traceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.apiClient.invokeAPI("/api/contract/list/{traceId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingContract> showContracts(String traceId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.showContractsRequestCreation(traceId, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingContract>>> showContractsWithHttpInfo(String traceId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>(){};
        return this.showContractsRequestCreation(traceId, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

