/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 21.2.8-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Details of the payment. Payment details will be empty if account type is AGENT
 */
@ApiModel(description = "Details of the payment. Payment details will be empty if account type is AGENT")
@JsonPropertyOrder({
  BookingContractPaymentDetails.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_VENDOR,
  BookingContractPaymentDetails.JSON_PROPERTY_TYPE,
  BookingContractPaymentDetails.JSON_PROPERTY_TRANSACTION_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_AGENT_INVOICED_DATE,
  BookingContractPaymentDetails.JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_VENDOR_SPECIFIC
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:35:18.045709+07:00[Asia/Bangkok]")
public class BookingContractPaymentDetails {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  /**
   * Name of acquiring vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    YAPILY("YAPILY"),
    
    PAY_PAL("PAY_PAL"),
    
    NMI("NMI"),
    
    AGENT("AGENT");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  /**
   * Technology taking the charge
   */
  public enum TypeEnum {
    CREDIT_CARD("CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER"),
    
    PAY_PAL("PAY_PAL"),
    
    CRYPTO("CRYPTO"),
    
    AGENT("AGENT"),
    
    CASH("CASH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TRANSACTION_IDENTIFIER = "transactionIdentifier";
  private String transactionIdentifier;

  public static final String JSON_PROPERTY_AGENT_INVOICED_DATE = "agentInvoicedDate";
  private OffsetDateTime agentInvoicedDate;

  public static final String JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER = "agentInvoiceIdentifier";
  private String agentInvoiceIdentifier;

  public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
  private Map<String, String> vendorSpecific = new HashMap<>();

  public BookingContractPaymentDetails() { 
  }

  public BookingContractPaymentDetails acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Unique acquiring identifier. Blank for agent payment
   * @return acquirerIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "STRIPE", required = true, value = "Unique acquiring identifier. Blank for agent payment")
  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public BookingContractPaymentDetails vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of acquiring vendor
   * @return vendor
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "STRIPE", required = true, value = "Name of acquiring vendor")
  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public BookingContractPaymentDetails type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Technology taking the charge
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "CREDIT_CARD", required = true, value = "Technology taking the charge")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractPaymentDetails transactionIdentifier(String transactionIdentifier) {
    
    this.transactionIdentifier = transactionIdentifier;
    return this;
  }

   /**
   * Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.
   * @return transactionIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "tx-1", required = true, value = "Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionIdentifier() {
    return transactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionIdentifier(String transactionIdentifier) {
    this.transactionIdentifier = transactionIdentifier;
  }


  public BookingContractPaymentDetails agentInvoicedDate(OffsetDateTime agentInvoicedDate) {
    
    this.agentInvoicedDate = agentInvoicedDate;
    return this;
  }

   /**
   * The date/time the invoice was generated
   * @return agentInvoicedDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The date/time the invoice was generated")
  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getAgentInvoicedDate() {
    return agentInvoicedDate;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgentInvoicedDate(OffsetDateTime agentInvoicedDate) {
    this.agentInvoicedDate = agentInvoicedDate;
  }


  public BookingContractPaymentDetails agentInvoiceIdentifier(String agentInvoiceIdentifier) {
    
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
    return this;
  }

   /**
   * The specific invoice this booking was registered on
   * @return agentInvoiceIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "invoice-1", required = true, value = "The specific invoice this booking was registered on")
  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAgentInvoiceIdentifier() {
    return agentInvoiceIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgentInvoiceIdentifier(String agentInvoiceIdentifier) {
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
  }


  public BookingContractPaymentDetails vendorSpecific(Map<String, String> vendorSpecific) {
    
    this.vendorSpecific = vendorSpecific;
    return this;
  }

  public BookingContractPaymentDetails putVendorSpecificItem(String key, String vendorSpecificItem) {
    this.vendorSpecific.put(key, vendorSpecificItem);
    return this;
  }

   /**
   * Vendor specific values that are returned in a successful response
   * @return vendorSpecific
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Vendor specific values that are returned in a successful response")
  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Map<String, String> getVendorSpecific() {
    return vendorSpecific;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorSpecific(Map<String, String> vendorSpecific) {
    this.vendorSpecific = vendorSpecific;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractPaymentDetails bookingContractPaymentDetails = (BookingContractPaymentDetails) o;
    return Objects.equals(this.acquirerIdentifier, bookingContractPaymentDetails.acquirerIdentifier) &&
        Objects.equals(this.vendor, bookingContractPaymentDetails.vendor) &&
        Objects.equals(this.type, bookingContractPaymentDetails.type) &&
        Objects.equals(this.transactionIdentifier, bookingContractPaymentDetails.transactionIdentifier) &&
        Objects.equals(this.agentInvoicedDate, bookingContractPaymentDetails.agentInvoicedDate) &&
        Objects.equals(this.agentInvoiceIdentifier, bookingContractPaymentDetails.agentInvoiceIdentifier) &&
        Objects.equals(this.vendorSpecific, bookingContractPaymentDetails.vendorSpecific);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, vendor, type, transactionIdentifier, agentInvoicedDate, agentInvoiceIdentifier, vendorSpecific);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractPaymentDetails {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    transactionIdentifier: ").append(toIndentedString(transactionIdentifier)).append("\n");
    sb.append("    agentInvoicedDate: ").append(toIndentedString(agentInvoicedDate)).append("\n");
    sb.append("    agentInvoiceIdentifier: ").append(toIndentedString(agentInvoiceIdentifier)).append("\n");
    sb.append("    vendorSpecific: ").append(toIndentedString(vendorSpecific)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

