/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.payment.model.Moneys;
import travel.wink.sdk.payment.model.SupplierContractItemPolicy;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Contract item cancellable object
 */
@ApiModel(description = "Contract item cancellable object")
@JsonPropertyOrder({
  BookingContractItemCancellableResponse.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItemCancellableResponse.JSON_PROPERTY_POLICY,
  BookingContractItemCancellableResponse.JSON_PROPERTY_TYPE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SOURCE_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SUPPLIER_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_DISPLAY_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_INTERNAL_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CAPTURE_PRICE,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractItemCancellableResponse.JSON_PROPERTY_CANCELLABLE_WITH_CHARGES,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SOURCE_PRICE_AFTER_CANCELLATION,
  BookingContractItemCancellableResponse.JSON_PROPERTY_SUPPLIER_PRICE_AFTER_CANCELLATION,
  BookingContractItemCancellableResponse.JSON_PROPERTY_DISPLAY_PRICE_AFTER_CANCELLATION,
  BookingContractItemCancellableResponse.JSON_PROPERTY_INTERNAL_PRICE_AFTER_CANCELLATION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:37:31.267868+07:00[Asia/Bangkok]")
public class BookingContractItemCancellableResponse {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicy policy;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_SOURCE_PRICE = "sourcePrice";
  private Moneys sourcePrice;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
  private Moneys supplierPrice;

  public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
  private Moneys displayPrice;

  public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
  private Moneys internalPrice;

  public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
  private Moneys capturePrice;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_CHARGES = "cancellableWithCharges";
  private Boolean cancellableWithCharges;

  public static final String JSON_PROPERTY_SOURCE_PRICE_AFTER_CANCELLATION = "sourcePriceAfterCancellation";
  private Moneys sourcePriceAfterCancellation;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_AFTER_CANCELLATION = "supplierPriceAfterCancellation";
  private Moneys supplierPriceAfterCancellation;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_AFTER_CANCELLATION = "displayPriceAfterCancellation";
  private Moneys displayPriceAfterCancellation;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_AFTER_CANCELLATION = "internalPriceAfterCancellation";
  private Moneys internalPriceAfterCancellation;

  public BookingContractItemCancellableResponse() { 
  }

  public BookingContractItemCancellableResponse supplierItemBookingCode(String supplierItemBookingCode) {
    
    this.supplierItemBookingCode = supplierItemBookingCode;
    return this;
  }

   /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "TP-ASDFG1234", value = "Booking code identifying the supplier line item.")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierItemBookingCode(String supplierItemBookingCode) {
    this.supplierItemBookingCode = supplierItemBookingCode;
  }


  public BookingContractItemCancellableResponse nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Name of item in English included in booking.
   * @return nameInEnglish
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Deluxe King", value = "Name of item in English included in booking.")
  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public BookingContractItemCancellableResponse policy(SupplierContractItemPolicy policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicy policy) {
    this.policy = policy;
  }


  public BookingContractItemCancellableResponse type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of item this is.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LODGING", value = "Type of item this is.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractItemCancellableResponse sourcePrice(Moneys sourcePrice) {
    
    this.sourcePrice = sourcePrice;
    return this;
  }

   /**
   * Get sourcePrice
   * @return sourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourcePrice() {
    return sourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePrice(Moneys sourcePrice) {
    this.sourcePrice = sourcePrice;
  }


  public BookingContractItemCancellableResponse supplierPrice(Moneys supplierPrice) {
    
    this.supplierPrice = supplierPrice;
    return this;
  }

   /**
   * Get supplierPrice
   * @return supplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSupplierPrice() {
    return supplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierPrice(Moneys supplierPrice) {
    this.supplierPrice = supplierPrice;
  }


  public BookingContractItemCancellableResponse displayPrice(Moneys displayPrice) {
    
    this.displayPrice = displayPrice;
    return this;
  }

   /**
   * Get displayPrice
   * @return displayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getDisplayPrice() {
    return displayPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayPrice(Moneys displayPrice) {
    this.displayPrice = displayPrice;
  }


  public BookingContractItemCancellableResponse internalPrice(Moneys internalPrice) {
    
    this.internalPrice = internalPrice;
    return this;
  }

   /**
   * Get internalPrice
   * @return internalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalPrice() {
    return internalPrice;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPrice(Moneys internalPrice) {
    this.internalPrice = internalPrice;
  }


  public BookingContractItemCancellableResponse capturePrice(Moneys capturePrice) {
    
    this.capturePrice = capturePrice;
    return this;
  }

   /**
   * Get capturePrice
   * @return capturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getCapturePrice() {
    return capturePrice;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapturePrice(Moneys capturePrice) {
    this.capturePrice = capturePrice;
  }


  public BookingContractItemCancellableResponse cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether this item can be cancelled by traveler either fully or partially.
   * @return cancellableByTraveler
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this item can be cancelled by traveler either fully or partially.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContractItemCancellableResponse cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether this item can be cancelled by supplier either fully or partially.
   * @return cancellableBySupplier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this item can be cancelled by supplier either fully or partially.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractItemCancellableResponse cancellableWithCharges(Boolean cancellableWithCharges) {
    
    this.cancellableWithCharges = cancellableWithCharges;
    return this;
  }

   /**
   * Whether this item can be cancelled by supplier either fully or partially.
   * @return cancellableWithCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this item can be cancelled by supplier either fully or partially.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithCharges() {
    return cancellableWithCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithCharges(Boolean cancellableWithCharges) {
    this.cancellableWithCharges = cancellableWithCharges;
  }


  public BookingContractItemCancellableResponse sourcePriceAfterCancellation(Moneys sourcePriceAfterCancellation) {
    
    this.sourcePriceAfterCancellation = sourcePriceAfterCancellation;
    return this;
  }

   /**
   * Get sourcePriceAfterCancellation
   * @return sourcePriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourcePriceAfterCancellation() {
    return sourcePriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePriceAfterCancellation(Moneys sourcePriceAfterCancellation) {
    this.sourcePriceAfterCancellation = sourcePriceAfterCancellation;
  }


  public BookingContractItemCancellableResponse supplierPriceAfterCancellation(Moneys supplierPriceAfterCancellation) {
    
    this.supplierPriceAfterCancellation = supplierPriceAfterCancellation;
    return this;
  }

   /**
   * Get supplierPriceAfterCancellation
   * @return supplierPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSupplierPriceAfterCancellation() {
    return supplierPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierPriceAfterCancellation(Moneys supplierPriceAfterCancellation) {
    this.supplierPriceAfterCancellation = supplierPriceAfterCancellation;
  }


  public BookingContractItemCancellableResponse displayPriceAfterCancellation(Moneys displayPriceAfterCancellation) {
    
    this.displayPriceAfterCancellation = displayPriceAfterCancellation;
    return this;
  }

   /**
   * Get displayPriceAfterCancellation
   * @return displayPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getDisplayPriceAfterCancellation() {
    return displayPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayPriceAfterCancellation(Moneys displayPriceAfterCancellation) {
    this.displayPriceAfterCancellation = displayPriceAfterCancellation;
  }


  public BookingContractItemCancellableResponse internalPriceAfterCancellation(Moneys internalPriceAfterCancellation) {
    
    this.internalPriceAfterCancellation = internalPriceAfterCancellation;
    return this;
  }

   /**
   * Get internalPriceAfterCancellation
   * @return internalPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalPriceAfterCancellation() {
    return internalPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPriceAfterCancellation(Moneys internalPriceAfterCancellation) {
    this.internalPriceAfterCancellation = internalPriceAfterCancellation;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItemCancellableResponse bookingContractItemCancellableResponse = (BookingContractItemCancellableResponse) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItemCancellableResponse.supplierItemBookingCode) &&
        Objects.equals(this.nameInEnglish, bookingContractItemCancellableResponse.nameInEnglish) &&
        Objects.equals(this.policy, bookingContractItemCancellableResponse.policy) &&
        Objects.equals(this.type, bookingContractItemCancellableResponse.type) &&
        Objects.equals(this.sourcePrice, bookingContractItemCancellableResponse.sourcePrice) &&
        Objects.equals(this.supplierPrice, bookingContractItemCancellableResponse.supplierPrice) &&
        Objects.equals(this.displayPrice, bookingContractItemCancellableResponse.displayPrice) &&
        Objects.equals(this.internalPrice, bookingContractItemCancellableResponse.internalPrice) &&
        Objects.equals(this.capturePrice, bookingContractItemCancellableResponse.capturePrice) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItemCancellableResponse.cancellableByTraveler) &&
        Objects.equals(this.cancellableBySupplier, bookingContractItemCancellableResponse.cancellableBySupplier) &&
        Objects.equals(this.cancellableWithCharges, bookingContractItemCancellableResponse.cancellableWithCharges) &&
        Objects.equals(this.sourcePriceAfterCancellation, bookingContractItemCancellableResponse.sourcePriceAfterCancellation) &&
        Objects.equals(this.supplierPriceAfterCancellation, bookingContractItemCancellableResponse.supplierPriceAfterCancellation) &&
        Objects.equals(this.displayPriceAfterCancellation, bookingContractItemCancellableResponse.displayPriceAfterCancellation) &&
        Objects.equals(this.internalPriceAfterCancellation, bookingContractItemCancellableResponse.internalPriceAfterCancellation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, nameInEnglish, policy, type, sourcePrice, supplierPrice, displayPrice, internalPrice, capturePrice, cancellableByTraveler, cancellableBySupplier, cancellableWithCharges, sourcePriceAfterCancellation, supplierPriceAfterCancellation, displayPriceAfterCancellation, internalPriceAfterCancellation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItemCancellableResponse {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    sourcePrice: ").append(toIndentedString(sourcePrice)).append("\n");
    sb.append("    supplierPrice: ").append(toIndentedString(supplierPrice)).append("\n");
    sb.append("    displayPrice: ").append(toIndentedString(displayPrice)).append("\n");
    sb.append("    internalPrice: ").append(toIndentedString(internalPrice)).append("\n");
    sb.append("    capturePrice: ").append(toIndentedString(capturePrice)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableWithCharges: ").append(toIndentedString(cancellableWithCharges)).append("\n");
    sb.append("    sourcePriceAfterCancellation: ").append(toIndentedString(sourcePriceAfterCancellation)).append("\n");
    sb.append("    supplierPriceAfterCancellation: ").append(toIndentedString(supplierPriceAfterCancellation)).append("\n");
    sb.append("    displayPriceAfterCancellation: ").append(toIndentedString(displayPriceAfterCancellation)).append("\n");
    sb.append("    internalPriceAfterCancellation: ").append(toIndentedString(internalPriceAfterCancellation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

