/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Primitive aggregate data points
 */
@ApiModel(description = "Primitive aggregate data points")
@JsonPropertyOrder({
  AggregateDescriptor.JSON_PROPERTY_FIELD,
  AggregateDescriptor.JSON_PROPERTY_AGGREGATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:32:50.158891+07:00[Asia/Bangkok]")
public class AggregateDescriptor {
  public static final String JSON_PROPERTY_FIELD = "field";
  private String field;

  /**
   * Aggregate function
   */
  public enum AggregateEnum {
    COUNT("count"),
    
    SUM("sum"),
    
    AVERAGE("average"),
    
    MIN("min"),
    
    MAX("max");

    private String value;

    AggregateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AggregateEnum fromValue(String value) {
      for (AggregateEnum b : AggregateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AGGREGATE = "aggregate";
  private AggregateEnum aggregate;

  public AggregateDescriptor() { 
  }

  public AggregateDescriptor field(String field) {
    
    this.field = field;
    return this;
  }

   /**
   * Field to run aggregate function on
   * @return field
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel.bookings", value = "Field to run aggregate function on")
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(String field) {
    this.field = field;
  }


  public AggregateDescriptor aggregate(AggregateEnum aggregate) {
    
    this.aggregate = aggregate;
    return this;
  }

   /**
   * Aggregate function
   * @return aggregate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "count", value = "Aggregate function")
  @JsonProperty(JSON_PROPERTY_AGGREGATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AggregateEnum getAggregate() {
    return aggregate;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregate(AggregateEnum aggregate) {
    this.aggregate = aggregate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AggregateDescriptor aggregateDescriptor = (AggregateDescriptor) o;
    return Objects.equals(this.field, aggregateDescriptor.field) &&
        Objects.equals(this.aggregate, aggregateDescriptor.aggregate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(field, aggregate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AggregateDescriptor {\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    aggregate: ").append(toIndentedString(aggregate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

