/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Describes a specific issue")
@JsonPropertyOrder(value={"taskId", "type", "text"})
public class AccountStatusEntry {
    public static final String JSON_PROPERTY_TASK_ID = "taskId";
    private UUID taskId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_TEXT = "text";
    private UUID text;

    public AccountStatusEntry taskId(UUID taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique task identifier.")
    @JsonProperty(value="taskId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTaskId() {
        return this.taskId;
    }

    @JsonProperty(value="taskId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public AccountStatusEntry type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="DISBURSEMENT", required=true, value="Type of textual entry")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AccountStatusEntry text(UUID text) {
        this.text = text;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Textual description of .")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setText(UUID text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountStatusEntry accountStatusEntry = (AccountStatusEntry)o;
        return Objects.equals(this.taskId, accountStatusEntry.taskId) && Objects.equals((Object)this.type, (Object)accountStatusEntry.type) && Objects.equals(this.text, accountStatusEntry.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.type, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountStatusEntry {\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MISSING_NATIONAL_IDENTIFIER("MISSING_NATIONAL_IDENTIFIER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

