/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="Existing customer payment methods")
@JsonPropertyOrder(value={"paymentMethodId", "brand", "nameOnCard", "last4", "expirationDate"})
public class CustomerPaymentMethod {
    public static final String JSON_PROPERTY_PAYMENT_METHOD_ID = "paymentMethodId";
    private String paymentMethodId;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_NAME_ON_CARD = "nameOnCard";
    private String nameOnCard;
    public static final String JSON_PROPERTY_LAST4 = "last4";
    private String last4;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    private String expirationDate;

    public CustomerPaymentMethod paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="pm_123456", required=true, value="Unique payment method identifier")
    @JsonProperty(value="paymentMethodId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @JsonProperty(value="paymentMethodId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public CustomerPaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="visa", required=true, value="Type of card")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public CustomerPaymentMethod nameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Avid Travelman", required=true, value="Name on card")
    @JsonProperty(value="nameOnCard")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameOnCard() {
        return this.nameOnCard;
    }

    @JsonProperty(value="nameOnCard")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    public CustomerPaymentMethod last4(String last4) {
        this.last4 = last4;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1111", required=true, value="Last 4 digits of card")
    @JsonProperty(value="last4")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLast4() {
        return this.last4;
    }

    @JsonProperty(value="last4")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public CustomerPaymentMethod expirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="12/24", required=true, value="Card expiration date")
    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerPaymentMethod customerPaymentMethod = (CustomerPaymentMethod)o;
        return Objects.equals(this.paymentMethodId, customerPaymentMethod.paymentMethodId) && Objects.equals(this.brand, customerPaymentMethod.brand) && Objects.equals(this.nameOnCard, customerPaymentMethod.nameOnCard) && Objects.equals(this.last4, customerPaymentMethod.last4) && Objects.equals(this.expirationDate, customerPaymentMethod.expirationDate);
    }

    public int hashCode() {
        return Objects.hash(this.paymentMethodId, this.brand, this.nameOnCard, this.last4, this.expirationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerPaymentMethod {\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    nameOnCard: ").append(this.toIndentedString(this.nameOnCard)).append("\n");
        sb.append("    last4: ").append(this.toIndentedString(this.last4)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

