/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="Holds tokenized credit card data")
@JsonPropertyOrder(value={"token", "obfuscatedNumber", "expirationDate", "scheme"})
public class NmiCreditCardToken {
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_OBFUSCATED_NUMBER = "obfuscatedNumber";
    private String obfuscatedNumber;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    private String expirationDate;
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private String scheme;

    public NmiCreditCardToken token(String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="H4waV564-UQ8FgJ-yXh495-Pb2ZeA3WNjvX", required=true, value="Tokenized credit card we can use to make a booking")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setToken(String token) {
        this.token = token;
    }

    public NmiCreditCardToken obfuscatedNumber(String obfuscatedNumber) {
        this.obfuscatedNumber = obfuscatedNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="424242******4242", required=true, value="Obfuscated credit card number used to create the token")
    @JsonProperty(value="obfuscatedNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getObfuscatedNumber() {
        return this.obfuscatedNumber;
    }

    @JsonProperty(value="obfuscatedNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObfuscatedNumber(String obfuscatedNumber) {
        this.obfuscatedNumber = obfuscatedNumber;
    }

    public NmiCreditCardToken expirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1224", required=true, value="Credit card expiration date")
    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public NmiCreditCardToken scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="visa", required=true, value="Credit card type")
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NmiCreditCardToken nmiCreditCardToken = (NmiCreditCardToken)o;
        return Objects.equals(this.token, nmiCreditCardToken.token) && Objects.equals(this.obfuscatedNumber, nmiCreditCardToken.obfuscatedNumber) && Objects.equals(this.expirationDate, nmiCreditCardToken.expirationDate) && Objects.equals(this.scheme, nmiCreditCardToken.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.obfuscatedNumber, this.expirationDate, this.scheme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NmiCreditCardToken {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    obfuscatedNumber: ").append(this.toIndentedString(this.obfuscatedNumber)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

