package travel.wink.sdk.payment.api;

import travel.wink.sdk.payment.invoker.ApiClient;

import travel.wink.sdk.payment.model.Account;
import travel.wink.sdk.payment.model.UpdateAccountStatusRequest;
import travel.wink.sdk.payment.model.UpsertAccountAcquirerRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:28:00.702907+07:00[Asia/Bangkok]")
public class AdministrationAccountControllerApi {
    private ApiClient apiClient;

    public AdministrationAccountControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AdministrationAccountControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Account Acquirer
     * Create account acquirer entry
     * <p><b>201</b> - Created
     * @param id The id parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountAcquirerRequestCreation(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        Object postBody = upsertAccountAcquirerRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountAcquirerRequest' is set
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/acquirer", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account Acquirer
     * Create account acquirer entry
     * <p><b>201</b> - Created
     * @param id The id parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> createAccountAcquirer(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountAcquirerWithHttpInfo(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest).toEntity(localVarReturnType);
    }
    /**
     * Remove Account Acquirer
     * Remove an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountAcquirerRequestCreation(String id, String acquirerId, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acquirerId' is set
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Account Acquirer
     * Remove an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param accept The accept parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> removeAccountAcquirer(String id, String acquirerId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountAcquirerRequestCreation(id, acquirerId, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountAcquirerWithHttpInfo(String id, String acquirerId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return removeAccountAcquirerRequestCreation(id, acquirerId, accept).toEntity(localVarReturnType);
    }
    /**
     * Update Account Acquirer
     * Update an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountAcquirerRequestCreation(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        Object postBody = upsertAccountAcquirerRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'acquirerId' is set
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAccountAcquirerRequest' is set
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Acquirer
     * Update an existing account acquirer entry
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param acquirerId The acquirerId parameter
     * @param upsertAccountAcquirerRequest The upsertAccountAcquirerRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccountAcquirer(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountAcquirerWithHttpInfo(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest).toEntity(localVarReturnType);
    }
    /**
     * Update Account Status
     * Update account status
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountStatusRequest The updateAccountStatusRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountStatusRequestCreation(String id, UpdateAccountStatusRequest updateAccountStatusRequest) throws WebClientResponseException {
        Object postBody = updateAccountStatusRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateAccountStatusRequest' is set
        if (updateAccountStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountStatusRequest' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return apiClient.invokeAPI("/api/administration/account/{id}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Status
     * Update account status
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateAccountStatusRequest The updateAccountStatusRequest parameter
     * @return Account
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Account> updateAccountStatus(String id, UpdateAccountStatusRequest updateAccountStatusRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountStatusRequestCreation(id, updateAccountStatusRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountStatusWithHttpInfo(String id, UpdateAccountStatusRequest updateAccountStatusRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>() {};
        return updateAccountStatusRequestCreation(id, updateAccountStatusRequest).toEntity(localVarReturnType);
    }
}
