/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 21.8.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.payment.model.RawSupplierContract;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * contract that started it all
 */
@ApiModel(description = "contract that started it all")
@JsonPropertyOrder({
  RawBookingContract.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER,
  RawBookingContract.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE,
  RawBookingContract.JSON_PROPERTY_DISPLAY_CURRENCY,
  RawBookingContract.JSON_PROPERTY_SOURCE_URL,
  RawBookingContract.JSON_PROPERTY_CONTRACT_LIST,
  RawBookingContract.JSON_PROPERTY_TRACE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:28:00.702907+07:00[Asia/Bangkok]")
public class RawBookingContract {
  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
  private UUID affiliateAccountIdentifier;

  /**
   * Type of identifier this is
   */
  public enum AffiliateAccountIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    AffiliateAccountIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
      for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
  private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_CONTRACT_LIST = "contractList";
  private List<RawSupplierContract> contractList = new ArrayList<>();

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public RawBookingContract() { 
  }

  public RawBookingContract affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    return this;
  }

   /**
   * affiliate account making the request
   * @return affiliateAccountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "affiliate account making the request")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAffiliateAccountIdentifier() {
    return affiliateAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
  }


  public RawBookingContract affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    return this;
  }

   /**
   * Type of identifier this is
   * @return affiliateAccountIdentifierType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Type of identifier this is")
  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
    return affiliateAccountIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
  }


  public RawBookingContract displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The desired quote
   * @return displayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "USD", required = true, value = "The desired quote")
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public RawBookingContract sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public RawBookingContract contractList(List<RawSupplierContract> contractList) {
    
    this.contractList = contractList;
    return this;
  }

  public RawBookingContract addContractListItem(RawSupplierContract contractListItem) {
    this.contractList.add(contractListItem);
    return this;
  }

   /**
   * Get contractList
   * @return contractList
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTRACT_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RawSupplierContract> getContractList() {
    return contractList;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContractList(List<RawSupplierContract> contractList) {
    this.contractList = contractList;
  }


  public RawBookingContract traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Integrator can choose to include a unique identifier to help identify the collection of bookings
   * @return traceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "integrator-booking-code-1", value = "Integrator can choose to include a unique identifier to help identify the collection of bookings")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RawBookingContract rawBookingContract = (RawBookingContract) o;
    return Objects.equals(this.affiliateAccountIdentifier, rawBookingContract.affiliateAccountIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifierType, rawBookingContract.affiliateAccountIdentifierType) &&
        Objects.equals(this.displayCurrency, rawBookingContract.displayCurrency) &&
        Objects.equals(this.sourceUrl, rawBookingContract.sourceUrl) &&
        Objects.equals(this.contractList, rawBookingContract.contractList) &&
        Objects.equals(this.traceId, rawBookingContract.traceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(affiliateAccountIdentifier, affiliateAccountIdentifierType, displayCurrency, sourceUrl, contractList, traceId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RawBookingContract {\n");
    sb.append("    affiliateAccountIdentifier: ").append(toIndentedString(affiliateAccountIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifierType: ").append(toIndentedString(affiliateAccountIdentifierType)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    contractList: ").append(toIndentedString(contractList)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

