/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.payment.invoker.ApiClient;
import travel.wink.sdk.payment.model.Account;
import travel.wink.sdk.payment.model.UpdateAccountStatusRequest;
import travel.wink.sdk.payment.model.UpsertAccountAcquirerRequest;

public class AdministrationAccountControllerApi {
    private ApiClient apiClient;

    public AdministrationAccountControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AdministrationAccountControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAccountAcquirerRequestCreation(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        UpsertAccountAcquirerRequest postBody = upsertAccountAcquirerRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling createAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/acquirer", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccountAcquirer(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountAcquirerWithHttpInfo(String id, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.createAccountAcquirerRequestCreation(id, upsertAccountAcquirerRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeAccountAcquirerRequestCreation(String id, String acquirerId, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling removeAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeAccountAcquirer(String id, String acquirerId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.removeAccountAcquirerRequestCreation(id, acquirerId, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountAcquirerWithHttpInfo(String id, String acquirerId, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.removeAccountAcquirerRequestCreation(id, acquirerId, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateAccountAcquirerRequestCreation(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        UpsertAccountAcquirerRequest postBody = upsertAccountAcquirerRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountAcquirerRequest' when calling updateAccountAcquirer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("acquirerId", acquirerId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/acquirer/{acquirerId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccountAcquirer(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountAcquirerWithHttpInfo(String id, String acquirerId, UpsertAccountAcquirerRequest upsertAccountAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountAcquirerRequestCreation(id, acquirerId, upsertAccountAcquirerRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateAccountStatusRequestCreation(String id, UpdateAccountStatusRequest updateAccountStatusRequest) throws WebClientResponseException {
        UpdateAccountStatusRequest postBody = updateAccountStatusRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateAccountStatusRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountStatusRequest' when calling updateAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/vnd.platform-v1+json", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.apiClient.invokeAPI("/api/administration/account/{id}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccountStatus(String id, UpdateAccountStatusRequest updateAccountStatusRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountStatusRequestCreation(id, updateAccountStatusRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountStatusWithHttpInfo(String id, UpdateAccountStatusRequest updateAccountStatusRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(){};
        return this.updateAccountStatusRequestCreation(id, updateAccountStatusRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

